/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModelBase<S extends State>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeModelBase.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final UndoManager myUndoManager;
    @NotNull
    private TIntArrayList myStartLines;
    @NotNull
    private TIntArrayList myEndLines;
    @NotNull
    private final TIntHashSet myChangesToUpdate;
    private int myBulkChangeUpdateDepth;
    private boolean myInsideCommand;
    private boolean myDisposed;

    public MergeModelBase(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/merge/MergeModelBase", "<init>"));
        }
        this.myStartLines = new TIntArrayList();
        this.myEndLines = new TIntArrayList();
        this.myChangesToUpdate = new TIntHashSet();
        this.myProject = project2;
        this.myDocument = document;
        this.myUndoManager = this.myProject != null ? UndoManager.getInstance((Project)this.myProject) : UndoManager.getGlobalInstance();
        this.myDocument.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        LOG.assertTrue(this.myBulkChangeUpdateDepth == 0);
        this.myStartLines.clear();
        this.myEndLines.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public int getChangesCount() {
        return this.myStartLines.size();
    }

    public int getLineStart(int index) {
        return this.myStartLines.get(index);
    }

    public int getLineEnd(int index) {
        return this.myEndLines.get(index);
    }

    public void setChanges(@NotNull List<LineRange> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/MergeModelBase", "setChanges"));
        }
        this.myStartLines.clear(changes.size());
        this.myEndLines.clear(changes.size());
        for (LineRange range : changes) {
            this.myStartLines.add(range.start);
            this.myEndLines.add(range.end);
        }
    }

    public boolean isInsideCommand() {
        return this.myInsideCommand;
    }

    private void setLineStart(int index, int line) {
        this.myStartLines.set(index, line);
    }

    private void setLineEnd(int index, int line) {
        this.myEndLines.set(index, line);
    }

    public void invalidateHighlighters(int index) {
        if (this.myBulkChangeUpdateDepth > 0) {
            this.myChangesToUpdate.add(index);
        } else {
            this.reinstallHighlighters(index);
        }
    }

    public void enterBulkChangeUpdateBlock() {
        ++this.myBulkChangeUpdateDepth;
    }

    public void exitBulkChangeUpdateBlock() {
        --this.myBulkChangeUpdateDepth;
        LOG.assertTrue(this.myBulkChangeUpdateDepth >= 0);
        if (this.myBulkChangeUpdateDepth == 0) {
            this.myChangesToUpdate.forEach(index -> {
                this.reinstallHighlighters(index);
                return true;
            });
            this.myChangesToUpdate.clear();
        }
    }

    protected abstract void reinstallHighlighters(int var1);

    @NotNull
    protected abstract S storeChangeState(int var1);

    protected void restoreChangeState(@NotNull S state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/merge/MergeModelBase", "restoreChangeState"));
        }
        this.setLineStart(((State)state).myIndex, ((State)state).myStartLine);
        this.setLineEnd(((State)state).myIndex, ((State)state).myEndLine);
    }

    @Nullable
    protected S processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
        int line1 = this.getLineStart(index);
        int line2 = this.getLineEnd(index);
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        S oldState = rangeAffected ? (S)this.storeChangeState(index) : null;
        this.setLineStart(index, newRange.startLine);
        this.setLineEnd(index, newRange.endLine);
        return oldState;
    }

    public boolean executeMergeCommand(@Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @Nullable TIntArrayList affectedChanges, @NotNull Runnable task2) {
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/merge/MergeModelBase", "executeMergeCommand"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/MergeModelBase", "executeMergeCommand"));
        }
        TIntArrayList allAffectedChanges = affectedChanges != null ? this.collectAffectedChanges(affectedChanges) : null;
        return DiffUtil.executeWriteCommand(this.myProject, this.myDocument, commandName, commandGroupId, confirmationPolicy, underBulkUpdate, () -> {
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/MergeModelBase", "lambda$executeMergeCommand$1"));
            }
            LOG.assertTrue(!this.myInsideCommand);
            this.myInsideCommand = true;
            this.enterBulkChangeUpdateBlock();
            try {
                this.registerUndoRedo(true, allAffectedChanges);
                try {
                    task2.run();
                }
                finally {
                    this.registerUndoRedo(false, allAffectedChanges);
                }
            }
            finally {
                this.exitBulkChangeUpdateBlock();
                this.myInsideCommand = false;
            }
        });
    }

    private void registerUndoRedo(boolean undo, @Nullable TIntArrayList affectedChanges) {
        ArrayList<S> states;
        if (this.myUndoManager == null) {
            return;
        }
        if (affectedChanges != null) {
            states = new ArrayList<S>(affectedChanges.size());
            affectedChanges.forEach(index -> {
                states.add(this.storeChangeState(index));
                return true;
            });
        } else {
            states = new ArrayList(this.getChangesCount());
            for (int index2 = 0; index2 < this.getChangesCount(); ++index2) {
                states.add(this.storeChangeState(index2));
            }
        }
        this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(this, states, undo));
    }

    public void replaceChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContent", "com/intellij/diff/merge/MergeModelBase", "replaceChange"));
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputStartLine, outputEndLine, newContent);
        if (outputStartLine == outputEndLine) {
            int newOutputEndLine = outputStartLine + newContent.size();
            this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
        }
    }

    public void appendChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContent", "com/intellij/diff/merge/MergeModelBase", "appendChange"));
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputEndLine, outputEndLine, newContent);
        int newOutputEndLine = outputEndLine + newContent.size();
        this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
    }

    private void moveChangesAfterInsertion(int index, int newOutputStartLine, int newOutputEndLine) {
        LOG.assertTrue(this.isInsideCommand());
        if (this.getLineStart(index) != newOutputStartLine || this.getLineEnd(index) != newOutputEndLine) {
            this.setLineStart(index, newOutputStartLine);
            this.setLineEnd(index, newOutputEndLine);
            this.invalidateHighlighters(index);
        }
        boolean beforeChange = true;
        for (int otherIndex = 0; otherIndex < this.getChangesCount(); ++otherIndex) {
            int newEndLine;
            int startLine = this.getLineStart(otherIndex);
            int endLine = this.getLineEnd(otherIndex);
            if (endLine < newOutputStartLine) continue;
            if (startLine > newOutputEndLine) break;
            if (index == otherIndex) {
                beforeChange = false;
                continue;
            }
            int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : Math.max(startLine, newOutputEndLine);
            int n2 = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
            if (startLine == newStartLine && endLine == newEndLine) continue;
            this.setLineStart(otherIndex, newStartLine);
            this.setLineEnd(otherIndex, newEndLine);
            this.invalidateHighlighters(otherIndex);
        }
    }

    @NotNull
    private TIntArrayList collectAffectedChanges(@NotNull TIntArrayList directChanges) {
        if (directChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directChanges", "com/intellij/diff/merge/MergeModelBase", "collectAffectedChanges"));
        }
        TIntArrayList result2 = new TIntArrayList(directChanges.size());
        int directArrayIndex = 0;
        int otherIndex = 0;
        while (directArrayIndex < directChanges.size() && otherIndex < this.getChangesCount()) {
            int directIndex = directChanges.get(directArrayIndex);
            if (directIndex == otherIndex) {
                result2.add(directIndex);
                ++otherIndex;
                continue;
            }
            int directStart = this.getLineStart(directIndex);
            int directEnd = this.getLineEnd(directIndex);
            int otherStart = this.getLineStart(otherIndex);
            int otherEnd = this.getLineEnd(otherIndex);
            if (otherEnd < directStart) {
                ++otherIndex;
                continue;
            }
            if (otherStart > directEnd) {
                ++directArrayIndex;
                continue;
            }
            result2.add(otherIndex);
            ++otherIndex;
        }
        LOG.assertTrue(directChanges.size() <= result2.size());
        TIntArrayList tIntArrayList = result2;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeModelBase", "collectAffectedChanges"));
        }
        return tIntArrayList;
    }

    public static class State {
        public final int myIndex;
        public final int myStartLine;
        public final int myEndLine;

        public State(int index, int startLine, int endLine) {
            this.myIndex = index;
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }
    }

    private static class MyUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final WeakReference<MergeModelBase> myModelRef;
        @NotNull
        private final List<? extends State> myStates;
        private final boolean myUndo;

        public MyUndoableAction(@NotNull MergeModelBase model2, @NotNull List<? extends State> states, boolean undo) {
            if (model2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/merge/MergeModelBase$MyUndoableAction", "<init>"));
            }
            if (states == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/diff/merge/MergeModelBase$MyUndoableAction", "<init>"));
            }
            super(new Document[]{model2.myDocument});
            this.myModelRef = new WeakReference<MergeModelBase>(model2);
            this.myStates = states;
            this.myUndo = undo;
        }

        public final void undo() throws UnexpectedUndoException {
            MergeModelBase model2 = (MergeModelBase)this.myModelRef.get();
            if (model2 != null && this.myUndo) {
                this.restoreStates(model2);
            }
        }

        public final void redo() throws UnexpectedUndoException {
            MergeModelBase model2 = (MergeModelBase)this.myModelRef.get();
            if (model2 != null && !this.myUndo) {
                this.restoreStates(model2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreStates(@NotNull MergeModelBase model2) {
            if (model2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/merge/MergeModelBase$MyUndoableAction", "restoreStates"));
            }
            if (model2.isDisposed()) {
                return;
            }
            if (model2.getChangesCount() == 0) {
                return;
            }
            model2.enterBulkChangeUpdateBlock();
            try {
                for (State state : this.myStates) {
                    model2.restoreChangeState(state);
                    model2.invalidateHighlighters(state.myIndex);
                }
            }
            finally {
                model2.exitBulkChangeUpdateBlock();
            }
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e2) {
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.enterBulkChangeUpdateBlock();
            if (MergeModelBase.this.getChangesCount() == 0) {
                return;
            }
            LineRange lineRange = DiffUtil.getAffectedLineRange(e2);
            int shift = DiffUtil.countLinesShift(e2);
            List corruptedStates = ContainerUtil.newSmartList();
            for (int index = 0; index < MergeModelBase.this.getChangesCount(); ++index) {
                Object oldState = MergeModelBase.this.processDocumentChange(index, lineRange.start, lineRange.end, shift);
                if (oldState == null) continue;
                MergeModelBase.this.invalidateHighlighters(index);
                if (MergeModelBase.this.isInsideCommand()) continue;
                corruptedStates.add(oldState);
            }
            if (MergeModelBase.this.myUndoManager != null && !corruptedStates.isEmpty()) {
                MergeModelBase.this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(MergeModelBase.this, corruptedStates, true));
            }
        }

        public void documentChanged(DocumentEvent e2) {
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.exitBulkChangeUpdateBlock();
        }
    }
}

