/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request2, final @NotNull MergeContext context2, final @NotNull MergeTool.MergeViewer viewer) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/MergeUtil", "createSimpleResolveAction"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "createSimpleResolveAction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "createSimpleResolveAction"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/merge/MergeUtil", "createSimpleResolveAction"));
        }
        String caption = MergeUtil.getResolveActionTitle(result2, request2, context2);
        AbstractAction abstractAction = new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request2, context2)) {
                    return;
                }
                context2.finishMerge(result2);
            }
        };
        if (abstractAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "createSimpleResolveAction"));
        }
        return abstractAction;
    }

    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @NotNull MergeRequest request2, @NotNull MergeContext context2) {
        String message2;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        Function<MergeResult, String> getter = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS);
        String string2 = message2 = getter != null ? (String)getter.fun((Object)result2) : null;
        if (message2 != null) {
            String string3 = message2;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
            }
            return string3;
        }
        switch (result2) {
            case CANCEL: {
                if ("Abort" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Abort";
            }
            case LEFT: {
                if ("Accept Left" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Accept Left";
            }
            case RIGHT: {
                if ("Accept Right" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Accept Right";
            }
            case RESOLVED: {
                if ("Apply" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Apply";
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContentTitles", "com/intellij/diff/merge/MergeUtil", "notNullizeContentTitles"));
        }
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)"Your Version");
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)"Base Version");
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)"Server Version");
        List list2 = ContainerUtil.list((Object[])new String[]{left, base, right});
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "notNullizeContentTitles"));
        }
        return list2;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request2, @NotNull MergeContext context2) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        Condition<MergeTool.MergeViewer> customHandler = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER);
        if (customHandler != null) {
            return customHandler.value((Object)viewer);
        }
        return MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request2, context2);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component, @NotNull MergeRequest request2, @NotNull MergeContext context2) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        String message2 = DiffBundle.message((String)"merge.dialog.exit.without.applying.changes.confirmation.message", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]);
        Couple<String> customMessage = DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE);
        if (customMessage != null) {
            title = (String)customMessage.first;
            message2 = (String)customMessage.second;
        }
        return Messages.showYesNoDialog((Component)component.getRootPane(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static void putRevisionInfos(@NotNull MergeRequest request2, @NotNull MergeData data) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "putRevisionInfos"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/merge/MergeUtil", "putRevisionInfos"));
        }
        if (request2 instanceof ThreesideMergeRequest) {
            List contents = ((ThreesideMergeRequest)request2).getContents();
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    public static void putRevisionInfos(@NotNull DiffRequest request2, @NotNull MergeData data) {
        List contents;
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "putRevisionInfos"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/merge/MergeUtil", "putRevisionInfos"));
        }
        if (request2 instanceof ContentDiffRequest && (contents = ((ContentDiffRequest)request2).getContents()).size() == 3) {
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    private static void putRevisionInfo(@NotNull List<? extends DiffContent> contents, @NotNull MergeData data) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/merge/MergeUtil", "putRevisionInfo"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/merge/MergeUtil", "putRevisionInfo"));
        }
        for (ThreeSide side : ThreeSide.values()) {
            DiffContent content2 = (DiffContent)side.select(contents);
            FilePath filePath = (FilePath)side.select((Object)data.CURRENT_FILE_PATH, (Object)data.ORIGINAL_FILE_PATH, (Object)data.LAST_FILE_PATH);
            VcsRevisionNumber revision = (VcsRevisionNumber)side.select((Object)data.CURRENT_REVISION_NUMBER, (Object)data.ORIGINAL_REVISION_NUMBER, (Object)data.LAST_REVISION_NUMBER);
            if (filePath == null || revision == null) continue;
            content2.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)Pair.create((Object)filePath, (Object)revision));
        }
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "<init>"));
            }
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocused() {
            return this.myMergeContext.isFocused();
        }

        public void requestFocus() {
            this.myMergeContext.requestFocus();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "getUserData"));
            }
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "putUserData"));
            }
            this.myMergeContext.putUserData(key, value2);
        }
    }
}

