/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalMergeTool {
    private static final Logger LOG = Logger.getInstance(ExternalMergeTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isMergeEnabled();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isMergeEnabled();
    }

    public static void show(@Nullable Project project2, @NotNull MergeRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/external/ExternalMergeTool", "show"));
        }
        try {
            if (ExternalMergeTool.canShow(request2)) {
                ExternalMergeTool.showRequest(project2, request2);
            } else {
                DiffManagerEx.getInstance().showMergeBuiltin(project2, request2);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Throwable e2) {
            LOG.warn(e2);
            Messages.showErrorDialog((Project)project2, (String)e2.getMessage(), (String)"Can't Show Merge In External Tool");
        }
    }

    public static void showRequest(@Nullable Project project2, @NotNull MergeRequest request2) throws ExecutionException, IOException {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/external/ExternalMergeTool", "showRequest"));
        }
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        ExternalDiffToolUtil.executeMerge(project2, settings, (ThreesideMergeRequest)request2);
    }

    public static boolean canShow(@NotNull MergeRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/external/ExternalMergeTool", "canShow"));
        }
        if (request2 instanceof ThreesideMergeRequest) {
            DiffContent outputContent = ((ThreesideMergeRequest)request2).getOutputContent();
            if (!ExternalMergeTool.canProcessOutputContent(outputContent)) {
                return false;
            }
            List contents = ((ThreesideMergeRequest)request2).getContents();
            if (contents.size() != 3) {
                return false;
            }
            for (DiffContent content2 : contents) {
                if (ExternalDiffToolUtil.canCreateFile(content2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean canProcessOutputContent(@NotNull DiffContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalMergeTool", "canProcessOutputContent"));
        }
        if (content2 instanceof DocumentContent) {
            return true;
        }
        return content2 instanceof FileContent && ((FileContent)content2).getFile().isInLocalFileSystem();
    }
}

