/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<Element> myPieces;

    public UnifiedEditorRangeHighlighter(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "<init>"));
        }
        this.myPieces = new ArrayList<Element>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, false);
        if (model2 == null) {
            return;
        }
        model2.processRangeHighlightersOverlappingWith(0, document.getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int newStart = marker.getStartOffset();
            int newEnd = marker.getEndOffset();
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public UnifiedEditorRangeHighlighter(@Nullable Project project2, @NotNull Document document1, @NotNull Document document2, @NotNull List<HighlightRange> ranges) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "<init>"));
        }
        this.myPieces = new ArrayList<Element>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument(document1, project2, false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document2, project2, false);
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<HighlightRange> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "init"));
        }
        for (HighlightRange range : ranges) {
            if (range.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, range);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, range);
        }
    }

    private void processRange(@NotNull MarkupModelEx model2, @NotNull HighlightRange range) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "processRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "processRange"));
        }
        TextRange base = range.getBase();
        TextRange changed = range.getChanged();
        int changedLength = changed.getEndOffset() - changed.getStartOffset();
        model2.processRangeHighlightersOverlappingWith(changed.getStartOffset(), changed.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int relativeStart = Math.max(marker.getStartOffset() - changed.getStartOffset(), 0);
            int relativeEnd = Math.min(marker.getEndOffset() - changed.getStartOffset(), changedLength);
            int newStart = base.getStartOffset() + relativeStart;
            int newEnd = base.getStartOffset() + relativeEnd;
            if (newEnd - newStart <= 0) {
                return true;
            }
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public static void erase(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "erase"));
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument(document, project2, true);
        model2.removeAllHighlighters();
    }

    public void apply(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter", "apply"));
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument(document, project2, true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate2 = piece.getDelegate();
            if (!delegate2.isValid()) continue;
            RangeHighlighter highlighter2 = model2.addRangeHighlighter(piece.getStart(), piece.getEnd(), delegate2.getLayer(), delegate2.getTextAttributes(), delegate2.getTargetArea());
            highlighter2.setEditorFilter(delegate2.getEditorFilter());
            highlighter2.setCustomRenderer(delegate2.getCustomRenderer());
            highlighter2.setErrorStripeMarkColor(delegate2.getErrorStripeMarkColor());
            highlighter2.setErrorStripeTooltip(delegate2.getErrorStripeTooltip());
            highlighter2.setGutterIconRenderer(delegate2.getGutterIconRenderer());
            highlighter2.setLineMarkerRenderer(delegate2.getLineMarkerRenderer());
            highlighter2.setLineSeparatorColor(delegate2.getLineSeparatorColor());
            highlighter2.setThinErrorStripeMark(delegate2.isThinErrorStripeMark());
            highlighter2.setLineSeparatorPlacement(delegate2.getLineSeparatorPlacement());
            highlighter2.setLineSeparatorRenderer(delegate2.getLineSeparatorRenderer());
        }
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        public Element(@NotNull RangeHighlighterEx delegate2, int start2, int end) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element", "<init>"));
            }
            this.myDelegate = delegate2;
            this.myStart = start2;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            RangeHighlighterEx rangeHighlighterEx = this.myDelegate;
            if (rangeHighlighterEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element", "getDelegate"));
            }
            return rangeHighlighterEx;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }
    }
}

