/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnifiedFragmentBuilder {
    @NotNull
    private final List<LineFragment> myFragments;
    @NotNull
    private final Document myDocument1;
    @NotNull
    private final Document myDocument2;
    @NotNull
    private final Side myMasterSide;
    @NotNull
    private final StringBuilder myBuilder;
    @NotNull
    private final List<ChangedBlock> myBlocks;
    @NotNull
    private final List<HighlightRange> myRanges;
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1;
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2;
    @NotNull
    private final List<LineRange> myChangedLines;
    private boolean myEqual;
    private int lastProcessedLine1;
    private int lastProcessedLine2;
    private int totalLines;

    public UnifiedFragmentBuilder(@NotNull List<LineFragment> fragments, @NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "<init>"));
        }
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "<init>"));
        }
        if (masterSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "<init>"));
        }
        this.myBuilder = new StringBuilder();
        this.myBlocks = new ArrayList<ChangedBlock>();
        this.myRanges = new ArrayList<HighlightRange>();
        this.myConvertor1 = new LineNumberConvertor.Builder();
        this.myConvertor2 = new LineNumberConvertor.Builder();
        this.myChangedLines = new ArrayList<LineRange>();
        this.myEqual = false;
        this.lastProcessedLine1 = -1;
        this.lastProcessedLine2 = -1;
        this.totalLines = 0;
        this.myFragments = fragments;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
        this.myMasterSide = masterSide;
    }

    public void exec() {
        if (this.myFragments.isEmpty()) {
            this.myEqual = true;
            this.appendTextMaster(0, 0, UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
            return;
        }
        for (LineFragment fragment : this.myFragments) {
            this.processEquals(fragment.getStartLine1() - 1, fragment.getStartLine2() - 1);
            this.processChanged(fragment);
        }
        this.processEquals(UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
    }

    private void processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
    }

    private void processChanged(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "processChanged"));
        }
        int startLine1 = fragment.getStartLine1();
        int endLine1 = fragment.getEndLine1() - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.getStartLine2();
        int endLine2 = fragment.getEndLine2() - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        if (lines1 >= 0) {
            int startOffset1 = this.myDocument1.getLineStartOffset(startLine1);
            int endOffset1 = this.myDocument1.getLineEndOffset(endLine1);
            this.appendTextSide(Side.LEFT, startOffset1, endOffset1, lines1, lines2, startLine1, -1);
        }
        int linesBetween = this.totalLines;
        if (lines2 >= 0) {
            int startOffset2 = this.myDocument2.getLineStartOffset(startLine2);
            int endOffset2 = this.myDocument2.getLineEndOffset(endLine2);
            this.appendTextSide(Side.RIGHT, startOffset2, endOffset2, lines2, lines2, -1, startLine2);
        }
        int linesAfter = this.totalLines;
        int blockStartLine1 = linesBefore;
        int blockEndLine1 = linesBetween;
        int blockStartLine2 = linesBetween;
        int blockEndLine2 = linesAfter;
        this.myBlocks.add(new ChangedBlock(new LineRange(blockStartLine1, blockEndLine1), new LineRange(blockStartLine2, blockEndLine2), fragment));
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
    }

    private void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines1 = endLine1 - startLine1;
        int lines2 = endLine2 - startLine2;
        if (this.myMasterSide.select(lines1, lines2) >= 0) {
            int startOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineStartOffset(startLine1) : this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineEndOffset(endLine1) : this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(this.myMasterSide, startOffset, endOffset, lines1, lines2, startLine1, startLine2);
        }
    }

    private void appendTextSide(@NotNull Side side, int offset1, int offset2, int lines1, int lines2, int startLine1, int startLine2) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "appendTextSide"));
        }
        int linesBefore = this.totalLines;
        this.appendText(side, offset1, offset2, lines1, lines2, startLine1, startLine2);
        int linesAfter = this.totalLines;
        if (linesBefore != linesAfter) {
            this.myChangedLines.add(new LineRange(linesBefore, linesAfter));
        }
    }

    private void appendText(@NotNull Side side, int offset1, int offset2, int lines1, int lines2, int startLine1, int startLine2) {
        int appendix;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "appendText"));
        }
        int lines = side.select(lines1, lines2);
        boolean notEmpty = lines >= 0;
        int n2 = appendix = notEmpty ? 1 : 0;
        if (startLine1 != -1) {
            this.myConvertor1.put(this.totalLines, startLine1, lines + appendix, lines1 + appendix);
        }
        if (startLine2 != -1) {
            this.myConvertor2.put(this.totalLines, startLine2, lines + appendix, lines2 + appendix);
        }
        if (notEmpty) {
            Document document = (Document)side.select((Object)this.myDocument1, (Object)this.myDocument2);
            int newline = document.getTextLength() > offset2 + 1 ? 1 : 0;
            TextRange base = new TextRange(this.myBuilder.length(), this.myBuilder.length() + offset2 - offset1 + newline);
            TextRange changed = new TextRange(offset1, offset2 + newline);
            this.myRanges.add(new HighlightRange(side, base, changed));
            this.myBuilder.append(document.getCharsSequence().subSequence(offset1, offset2));
            this.myBuilder.append('\n');
            this.totalLines += lines + 1;
        }
    }

    private static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }

    public boolean isEqual() {
        return this.myEqual;
    }

    @NotNull
    public CharSequence getText() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getText"));
        }
        return stringBuilder;
    }

    @NotNull
    public List<ChangedBlock> getBlocks() {
        List<ChangedBlock> list2 = this.myBlocks;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getBlocks"));
        }
        return list2;
    }

    @NotNull
    public List<HighlightRange> getRanges() {
        List<HighlightRange> list2 = this.myRanges;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getRanges"));
        }
        return list2;
    }

    @NotNull
    public LineNumberConvertor getConvertor1() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor1.build();
        if (lineNumberConvertor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getConvertor1"));
        }
        return lineNumberConvertor;
    }

    @NotNull
    public LineNumberConvertor getConvertor2() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor2.build();
        if (lineNumberConvertor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getConvertor2"));
        }
        return lineNumberConvertor;
    }

    @NotNull
    public List<LineRange> getChangedLines() {
        List<LineRange> list2 = this.myChangedLines;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder", "getChangedLines"));
        }
        return list2;
    }
}

