/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.holders;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHolder
extends EditorHolder {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Wrapper myPanel;

    public TextEditorHolder(@Nullable Project project2, @NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/holders/TextEditorHolder", "<init>"));
        }
        this.myEditor = editor;
        this.myPanel = new Wrapper(this.myEditor.getComponent());
        DataManager.registerDataProvider((JComponent)this.myPanel, dataId -> {
            Object o2;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/holders/TextEditorHolder", "lambda$new$0"));
            }
            if (project2 != null && !project2.isDisposed() && Registry.is((String)"diff.pass.rich.editor.context") && (o2 = FileEditorManager.getInstance((Project)project2).getData(dataId, (Editor)editor, editor.getCaretModel().getCurrentCaret())) != null) {
                return o2;
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return editor;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return editor.getVirtualFile();
            }
            return null;
        });
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/TextEditorHolder", "getEditor"));
        }
        return editorEx;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        Wrapper wrapper = this.myPanel;
        if (wrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/TextEditorHolder", "getComponent"));
        }
        return wrapper;
    }

    @Override
    public void installFocusListener(@NotNull FocusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/diff/tools/holders/TextEditorHolder", "installFocusListener"));
        }
        this.myEditor.getContentComponent().addFocusListener(listener2);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    @NotNull
    public static TextEditorHolder create(@Nullable Project project2, @NotNull DocumentContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/TextEditorHolder", "create"));
        }
        EditorEx editor = DiffUtil.createEditor(content2.getDocument(), project2, false, true);
        DiffUtil.configureEditor(editor, content2, project2);
        TextEditorHolder textEditorHolder = new TextEditorHolder(project2, editor);
        if (textEditorHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/TextEditorHolder", "create"));
        }
        return textEditorHolder;
    }

    public static class TextEditorHolderFactory
    extends EditorHolderFactory<TextEditorHolder> {
        public static TextEditorHolderFactory INSTANCE = new TextEditorHolderFactory();

        @Override
        @NotNull
        public TextEditorHolder create(@NotNull DiffContent content2, @NotNull DiffContext context2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "create"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "create"));
            }
            TextEditorHolder textEditorHolder = TextEditorHolder.create(context2.getProject(), (DocumentContent)content2);
            if (textEditorHolder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "create"));
            }
            return textEditorHolder;
        }

        @Override
        public boolean canShowContent(@NotNull DiffContent content2, @NotNull DiffContext context2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "canShowContent"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "canShowContent"));
            }
            return content2 instanceof DocumentContent;
        }

        @Override
        public boolean wantShowContent(@NotNull DiffContent content2, @NotNull DiffContext context2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "wantShowContent"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/TextEditorHolder$TextEditorHolderFactory", "wantShowContent"));
            }
            return content2 instanceof DocumentContent;
        }
    }
}

