/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleThreesideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    private final SimpleThreesideTextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        super(context2, (ContentDiffRequest)request2);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myTextDiffProvider = new SimpleThreesideTextDiffProvider(this.getTextSettings(), this::rediff, (Disposable)this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.addAll(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            List sequences = ContainerUtil.map(this.getContents(), content2 -> content2.getDocument().getImmutableCharSequence());
            List<FineMergeLineFragment> lineFragments = this.myTextDiffProvider.compare((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), indicator);
            runnable2 = this.apply(lineFragments);
        }
        catch (DiffTooBigException e2) {
            Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        catch (ProcessCanceledException e3) {
            throw e3;
        }
        catch (Throwable e4) {
            LOG.error(e4);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    @NotNull
    private Runnable apply(@NotNull List<FineMergeLineFragment> fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        Runnable runnable2 = () -> {
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "lambda$apply$1"));
            }
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (FineMergeLineFragment fragment : fragments) {
                MergeConflictType conflictType = fragment.getConflictType();
                MergeInnerDifferences innerFragments = fragment.getInnerFragments();
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType, innerFragments, this);
                this.myDiffChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(fragments, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        return runnable2;
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroy();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroy();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e2);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue((List)documents, (Object)e2.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e2);
        int shift = DiffUtil.countLinesShift(e2);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list2 = this.myDiffChanges;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChanges"));
        }
        return list2;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
        if (myDividerPaintable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        return myDividerPaintable;
    }

    public static boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        return ThreesideTextDiffViewer.canShowRequest(context2, request2);
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        public MyDividerPaintable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "process"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }
}

