/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FocusTrackerSupport<S> {
    @NotNull
    public abstract S getCurrentSide();

    public abstract void setCurrentSide(@NotNull S var1);

    public abstract void processContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public abstract void updateContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public static class Threeside
    extends FocusTrackerSupport<ThreeSide> {
        @NotNull
        private ThreeSide myCurrentSide;

        public Threeside(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "<init>"));
            }
            this.myCurrentSide = ThreeSide.BASE;
            this.addListener(holders, ThreeSide.LEFT);
            this.addListener(holders, ThreeSide.BASE);
            this.addListener(holders, ThreeSide.RIGHT);
        }

        @Override
        @NotNull
        public ThreeSide getCurrentSide() {
            ThreeSide threeSide = this.myCurrentSide;
            if (threeSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "getCurrentSide"));
            }
            return threeSide;
        }

        @Override
        public void setCurrentSide(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "setCurrentSide"));
            }
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context2) {
            if (request2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "processContextHints"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "processContextHints"));
            }
            ThreeSide side = (ThreeSide)DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context2) {
            if (request2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "updateContextHints"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "updateContextHints"));
            }
            context2.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull ThreeSide side) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "addListener"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside", "addListener"));
            }
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final ThreeSide mySide;

            private MyFocusListener(ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e2) {
                Threeside.this.myCurrentSide = this.mySide;
            }
        }
    }

    public static class Twoside
    extends FocusTrackerSupport<Side> {
        @NotNull
        private Side myCurrentSide;

        public Twoside(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "<init>"));
            }
            assert (holders.size() == 2);
            this.myCurrentSide = Side.RIGHT;
            this.addListener(holders, Side.LEFT);
            this.addListener(holders, Side.RIGHT);
        }

        @Override
        @NotNull
        public Side getCurrentSide() {
            Side side = this.myCurrentSide;
            if (side == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "getCurrentSide"));
            }
            return side;
        }

        @Override
        public void setCurrentSide(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "setCurrentSide"));
            }
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context2) {
            if (request2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "processContextHints"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "processContextHints"));
            }
            Side side = (Side)DiffUtil.getUserData((UserDataHolder)request2, (UserDataHolder)context2, DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context2) {
            if (request2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "updateContextHints"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "updateContextHints"));
            }
            context2.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull Side side) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "addListener"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside", "addListener"));
            }
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final Side mySide;

            private MyFocusListener(Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e2) {
                Twoside.this.myCurrentSide = this.mySide;
            }
        }
    }
}

