/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardModifierListener
implements Disposable {
    private boolean myShiftPressed;
    private boolean myCtrlPressed;
    private boolean myAltPressed;
    @Nullable
    private Window myWindow;
    private final WindowFocusListener myWindowFocusListener = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent e2) {
            KeyboardModifierListener.this.resetState();
        }

        @Override
        public void windowLostFocus(WindowEvent e2) {
            KeyboardModifierListener.this.resetState();
        }
    };

    public void init(@NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/tools/util/KeyboardModifierListener", "init"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/KeyboardModifierListener", "init"));
        }
        assert (this.myWindow == null);
        Disposer.register((Disposable)disposable, (Disposable)this);
        IdeEventQueue.getInstance().addPostprocessor(e2 -> {
            if (e2 instanceof KeyEvent) {
                this.onKeyEvent((KeyEvent)e2);
            }
            return false;
        }, disposable);
        this.myWindow = UIUtil.getWindow((Component)component);
        if (this.myWindow != null) {
            this.myWindow.addWindowFocusListener(this.myWindowFocusListener);
        }
    }

    public void dispose() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowFocusListener(this.myWindowFocusListener);
            this.myWindow = null;
        }
    }

    private void onKeyEvent(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        if (keyCode == 16) {
            this.myShiftPressed = e2.getID() == 401;
            this.onModifiersChanged();
        }
        if (keyCode == 17) {
            this.myCtrlPressed = e2.getID() == 401;
            this.onModifiersChanged();
        }
        if (keyCode == 18) {
            this.myAltPressed = e2.getID() == 401;
            this.onModifiersChanged();
        }
    }

    private void resetState() {
        this.myShiftPressed = false;
        this.myAltPressed = false;
        this.myCtrlPressed = false;
        this.onModifiersChanged();
    }

    public boolean isShiftPressed() {
        return this.myShiftPressed;
    }

    public boolean isCtrlPressed() {
        return this.myCtrlPressed;
    }

    public boolean isAltPressed() {
        return this.myAltPressed;
    }

    public void onModifiersChanged() {
    }
}

