/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffPanel
extends DiffPanelBase {
    private static final String GOOD_CONTENT = "GoodContent";
    private static final String ERROR_CONTENT = "ErrorContent";

    public SimpleDiffPanel(@NotNull JComponent editorPanel, @NotNull DataProvider dataProvider, @NotNull DiffContext context2) {
        if (editorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPanel", "com/intellij/diff/tools/util/SimpleDiffPanel", "<init>"));
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/diff/tools/util/SimpleDiffPanel", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/SimpleDiffPanel", "<init>"));
        }
        super(context2.getProject(), dataProvider, context2);
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel((Component)editorPanel).addToTop((Component)this.myNotificationsPanel);
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.setCurrentCard(GOOD_CONTENT, false);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setErrorContent() {
        this.setErrorContent("Error");
    }

    public void setErrorContent(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/tools/util/SimpleDiffPanel", "setErrorContent"));
        }
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(message2), ERROR_CONTENT);
        this.setCurrentCard(ERROR_CONTENT);
    }

    public boolean isGoodContent() {
        return this.myCurrentCard == GOOD_CONTENT;
    }
}

