/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements DataProvider {
    @Nullable
    protected final Project myProject;
    @NotNull
    private final DataProvider myDataProvider;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    private final List<JComponent> myPersistentNotifications;
    @NotNull
    private final List<JComponent> myNotifications;
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final Wrapper myNotificationsPanel;
    @NotNull
    private final Wrapper myNorthPanel;
    @NotNull
    private final Wrapper mySouthPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project2, @NotNull DataProvider provider, @NotNull DiffContext context2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        super(new BorderLayout());
        this.myPersistentNotifications = new ArrayList<JComponent>();
        this.myNotifications = new ArrayList<JComponent>();
        this.myProject = project2;
        this.myDataProvider = provider;
        this.myContext = context2;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new Wrapper();
        this.myNorthPanel = new Wrapper();
        this.mySouthPanel = new Wrapper();
        this.add((Component)this.myContentPanel, "Center");
        this.add((Component)this.myNorthPanel, "North");
        this.add((Component)this.mySouthPanel, "South");
    }

    public void setTopPanel(@Nullable JComponent component) {
        this.myNorthPanel.setContent(component);
    }

    public void setBottomPanel(@Nullable JComponent component) {
        this.mySouthPanel.setContent(component);
    }

    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        boolean restoreFocus = keepFocus && this.myContext.isFocused();
        this.myCardLayout.show(this.myContentPanel, card);
        this.myCurrentCard = card;
        this.myContentPanel.revalidate();
        if (restoreFocus) {
            this.myContext.requestFocus();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.myDataProvider.getData(dataId);
    }

    public void setPersistentNotifications(@NotNull List<JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/tools/util/base/DiffPanelBase", "setPersistentNotifications"));
        }
        this.myPersistentNotifications.clear();
        this.myPersistentNotifications.addAll(components);
        this.updateNotifications();
    }

    public void resetNotifications() {
        this.myNotifications.clear();
        this.updateNotifications();
    }

    public void addNotification(@NotNull JComponent notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/diff/tools/util/base/DiffPanelBase", "addNotification"));
        }
        this.myNotifications.add(notification);
        this.updateNotifications();
    }

    private void updateNotifications() {
        List notifications = ContainerUtil.concat(this.myPersistentNotifications, this.myNotifications);
        this.myNotificationsPanel.setContent(DiffUtil.createStackedComponents(notifications, DiffUtil.TITLE_GAP));
        this.validate();
        this.repaint();
    }
}

