/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.comparison.ComparisonPolicy;
import org.jetbrains.annotations.NotNull;

public enum IgnorePolicy {
    DEFAULT("Do not ignore"),
    TRIM_WHITESPACES("Trim whitespaces"),
    IGNORE_WHITESPACES("Ignore whitespaces"),
    IGNORE_WHITESPACES_CHUNKS("Ignore whitespaces and empty lines"),
    FORMATTING("Ignore formatting");

    @NotNull
    private final String myText;

    private IgnorePolicy(String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/IgnorePolicy", "<init>"));
        }
        this.myText = text2;
    }

    @NotNull
    public String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getText"));
        }
        return string2;
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        switch (this) {
            case DEFAULT: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.DEFAULT;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case TRIM_WHITESPACES: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.TRIM_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case IGNORE_WHITESPACES: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.IGNORE_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case IGNORE_WHITESPACES_CHUNKS: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.IGNORE_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case FORMATTING: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.DEFAULT;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public boolean isShouldTrimChunks() {
        return this == IGNORE_WHITESPACES_CHUNKS;
    }
}

