/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends ThreesideDiffViewer<TextEditorHolder> {
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener1;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener2;
    @Nullable
    protected SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollSupport;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;

    public ThreesideTextDiffViewer(@NotNull DiffContext context2, @NotNull ContentDiffRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "<init>"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "<init>"));
        }
        super(context2, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myVisibleAreaListener1 = new MyVisibleAreaListener(Side.LEFT);
        this.myVisibleAreaListener2 = new MyVisibleAreaListener(Side.RIGHT);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorHolders"));
        }
        List<TextEditorHolder> holders = super.createEditorHolders(factory2);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!forceReadOnly[i2]) continue;
            holders.get(i2).getEditor().setViewer(true);
        }
        ((TextEditorHolder)ThreeSide.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        ((EditorMarkupModel)((Object)((TextEditorHolder)ThreeSide.BASE.select(holders)).getEditor().getMarkupModel())).setErrorStripeVisible(false);
        for (TextEditorHolder holder : holders) {
            DiffUtil.disableBlitting(holder.getEditor());
        }
        List<TextEditorHolder> list2 = holders;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorHolders"));
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list2 = DiffUtil.createSyncHeightComponents(DiffUtil.createTextTitles(this.myRequest, this.getEditors()));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createTitles"));
        }
        return list2;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(ThreeSide.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.ThreesideSyncScrollSupport(this.getEditors(), scrollable1, scrollable2);
            this.myEditorSettingsAction.setSyncScrollSupport(this.mySyncScrollSupport);
        }
    }

    public void destroyEditorListeners() {
        this.getEditor(ThreeSide.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            if (disable) {
                this.mySyncScrollSupport.enterDisableScrollSection();
            } else {
                this.mySyncScrollSupport.exitDisableScrollSection();
            }
        }
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list2 = TextDiffViewerUtil.createEditorPopupActions();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorPopupActions"));
        }
        return list2;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = this.getContent(this.getCurrentSide());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getCurrentContent"));
        }
        return documentContent;
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list2 = this.myRequest.getContents();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContents"));
        }
        return list2;
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), holder -> holder.getEditor());
        }
        List<? extends EditorEx> list2 = this.myEditors;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditors"));
        }
        return list2;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list2 = this.myEditableEditors;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditableEditors"));
        }
        return list2;
    }

    @NotNull
    public EditorEx getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditor"));
        }
        EditorEx editorEx = (EditorEx)side.select(this.getEditors());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContent"));
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContent"));
        }
        return documentContent;
    }

    @Nullable
    public ThreeSide getEditorSide(@Nullable Editor editor) {
        if (this.getEditor(ThreeSide.BASE) == editor) {
            return ThreeSide.BASE;
        }
        if (this.getEditor(ThreeSide.RIGHT) == editor) {
            return ThreeSide.RIGHT;
        }
        if (this.getEditor(ThreeSide.LEFT) == editor) {
            return ThreeSide.LEFT;
        }
        return null;
    }

    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "scrollToLine"));
        }
        DiffUtil.scrollEditor(this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @NotNull
    protected LogicalPosition transferPosition(@NotNull ThreeSide baseSide, @NotNull ThreeSide targetSide, @NotNull LogicalPosition position) {
        if (baseSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSide", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
        }
        if (targetSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetSide", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
        }
        if (this.mySyncScrollSupport == null) {
            LogicalPosition logicalPosition = position;
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
            }
            return logicalPosition;
        }
        if (baseSide == targetSide) {
            LogicalPosition logicalPosition = position;
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
            }
            return logicalPosition;
        }
        SyncScrollSupport.SyncScrollable scrollable12 = this.mySyncScrollSupport.getScrollable12();
        SyncScrollSupport.SyncScrollable scrollable23 = this.mySyncScrollSupport.getScrollable23();
        int baseLine = baseSide == ThreeSide.LEFT ? scrollable12.transfer(Side.LEFT, position.line) : (baseSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.RIGHT, position.line) : position.line);
        int targetLine = targetSide == ThreeSide.LEFT ? scrollable12.transfer(Side.RIGHT, baseLine) : (targetSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.LEFT, baseLine) : baseLine);
        LogicalPosition logicalPosition = new LogicalPosition(targetLine, position.column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "transferPosition"));
        }
        return logicalPosition;
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getCurrentContent().getNavigatable(LineCol.fromCaret((Editor)this.getCurrentEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "canShowRequest"));
        }
        return ThreesideDiffViewer.canShowRequest(context2, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    protected class TextShowPartialDiffAction
    extends ThreesideDiffViewer.ShowPartialDiffAction {
        public TextShowPartialDiffAction(ThreesideDiffViewer.PartialDiffMode mode) {
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$TextShowPartialDiffAction", "<init>"));
            }
            super(mode);
        }

        @Override
        @NotNull
        protected SimpleDiffRequest createRequest() {
            SimpleDiffRequest request2 = super.createRequest();
            ThreeSide currentSide = ThreesideTextDiffViewer.this.getCurrentSide();
            LogicalPosition currentPosition = DiffUtil.getCaretPosition(ThreesideTextDiffViewer.this.getCurrentEditor());
            if (currentSide == this.mySide1) {
                request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)currentPosition.line));
            } else if (currentSide == this.mySide2) {
                request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            } else {
                LogicalPosition position1 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide1, currentPosition);
                LogicalPosition position2 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide2, currentPosition);
                request2.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)new LogicalPosition[]{position1, position2});
            }
            SimpleDiffRequest simpleDiffRequest = request2;
            if (simpleDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$TextShowPartialDiffAction", "createRequest"));
            }
            return simpleDiffRequest;
        }
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.ThreesideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list2 = ThreesideTextDiffViewer.this.getEditors();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
            }
            return list2;
        }

        @Override
        protected void disableSyncScroll(boolean value2) {
            ThreesideTextDiffViewer.this.disableSyncScrollSupport(value2);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.scrollToLine((ThreeSide)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        @NotNull
        Side mySide;

        public MyVisibleAreaListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyVisibleAreaListener", "<init>"));
            }
            this.mySide = side;
        }

        public void visibleAreaChanged(VisibleAreaEvent e2) {
            if (ThreesideTextDiffViewer.this.mySyncScrollSupport != null) {
                ThreesideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e2);
            }
            ThreesideTextDiffViewer.this.myContentPanel.repaint();
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(ThreesideTextDiffViewer.this.getTextSettings());
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
            }
            ThreeSide side = ThreesideTextDiffViewer.this.getEditorSide(editor);
            if (side == null) {
                return null;
            }
            return ThreesideTextDiffViewer.this.getContent(side).getNavigatable(new LineCol(line));
        }
    }
}

