/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    public static final int STRIPE_LAYER = 4999;
    public static final int DEFAULT_LAYER = 5997;
    public static final int INLINE_LAYER = 5998;
    public static final int LINE_MARKER_LAYER = 5999;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g2, int x1, int x2, int y2) {
            Rectangle clip = g2.getClipBounds();
            x2 = clip.x + clip.width;
            g2.setColor(JBColor.border());
            g2.drawLine(x1, y2, x2, y2);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        Color color = DiffDrawUtil.getDividerColor(null);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        Color color = DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        Color gutterBackground = scheme2.getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        return color;
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g2, int x1, int x2, int start1, int end1, int start2, int end2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffDrawUtil.drawConnectorLineSeparator(g2, x1, x2, start1, end1, start2, end2, null);
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g2, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable EditorColorsScheme scheme2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffLineSeparatorRenderer.drawConnectorLine(g2, x1, x2, start1, start2, end1 - start1, scheme2);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g2, int x1, int x2, int y2, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)(y2 - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)y2, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)(y2 - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g2, (int)x1, (int)y2, (int)x2, (int)y2, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g2, (int)x1, (int)(y2 + 1), (int)x2, (int)(y2 + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g2, (int)x1, (int)y2, (int)x2, (int)y2, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g2, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawTrapezium"));
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g2.setColor(fillColor);
            g2.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g2.setColor(borderColor);
            g2.drawLine(x1, start1, x2, start2);
            g2.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g2, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawCurveTrapezium"));
        }
        Shape upperCurve = DiffDrawUtil.makeCurve(x1, x2, start1, start2, true);
        Shape lowerCurve = DiffDrawUtil.makeCurve(x1, x2, end1 + 1, end2 + 1, false);
        Shape lowerCurveBorder = DiffDrawUtil.makeCurve(x1, x2, end1, end2, false);
        if (fillColor != null) {
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g2.setColor(fillColor);
            g2.fill(path);
        }
        if (borderColor != null) {
            g2.setColor(borderColor);
            g2.draw(upperCurve);
            g2.draw(lowerCurveBorder);
        }
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "lineToY"));
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y2 = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(document) - 1);
            return y2 + editor.getLineHeight() * (line - DiffUtil.getLineCount(document) + 1);
        }
        return editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getLineStartOffset((int)line))).y;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type, final @Nullable Editor editor, final boolean ignored) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getBackgroundColor() {
                return ignored ? type.getIgnoredColor(editor) : type.getColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type, final @NotNull Editor editor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return type.getMarkerColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        return textAttributes;
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter2, @NotNull TextDiffType type) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        highlighter2.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g2, int x1, int x2, int y2) {
                Rectangle clip = g2.getClipBounds();
                x2 = clip.x + clip.width;
                if (placement == SeparatorPlacement.TOP) {
                    ++y2;
                }
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g2, x1, x2, y2, type.getColor(editor), doubleLine, resolved);
            }
        };
        if (lineSeparatorRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        return lineSeparatorRenderer;
    }

    @NotNull
    private static LineMarkerRenderer createFoldingGutterLineRenderer(final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createFoldingGutterLineRenderer"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createFoldingGutterLineRenderer"));
        }
        LineMarkerRendererEx lineMarkerRendererEx = new LineMarkerRendererEx(){

            public void paint(Editor editor, Graphics g2, Rectangle r2) {
                EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
                Graphics2D g22 = (Graphics2D)g2;
                int x1 = gutter.getWhitespaceSeparatorOffset();
                int x2 = gutter.getWidth();
                int y2 = r2.y;
                if (placement == SeparatorPlacement.BOTTOM) {
                    y2 += editor.getLineHeight();
                }
                DiffDrawUtil.drawChunkBorderLine(g22, x1, x2, y2 - 1, type.getColor(editor), doubleLine, resolved);
            }

            @Override
            @NotNull
            public LineMarkerRendererEx.Position getPosition() {
                LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
                if (position == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$5", "getPosition"));
                }
                return position;
            }
        };
        if (lineMarkerRendererEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createFoldingGutterLineRenderer"));
        }
        return lineMarkerRendererEx;
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<DiffFragment> innerFragments) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createUnifiedChunkHighlighters"));
        }
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/diff/util/DiffDrawUtil", "createUnifiedChunkHighlighters"));
        }
        if (inserted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inserted", "com/intellij/diff/util/DiffDrawUtil", "createUnifiedChunkHighlighters"));
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list2 = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!inserted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
        }
        if (innerFragments != null) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment fragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + fragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + fragment.getEndOffset1();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + fragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + fragment.getEndOffset2();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        ArrayList<RangeHighlighter> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createUnifiedChunkHighlighters"));
        }
        return arrayList;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).done();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean resolved, boolean hideWithoutLineNumbers) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(hideWithoutLineNumbers).done();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        List<RangeHighlighter> list2 = new InlineHighlighterBuilder(editor, start2, end, type).done();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (line == 0) {
            List<RangeHighlighter> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
            }
            return list2;
        }
        List<RangeHighlighter> list3 = DiffDrawUtil.createLineMarker(editor, line - 1, type, SeparatorPlacement.BOTTOM, false, false, true);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list3;
    }

    @NotNull
    private static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type, @NotNull SeparatorPlacement placement, boolean doubleLine, boolean resolved, boolean paintFoldingOutline) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        LineMarkerBuilder builder = new LineMarkerBuilder(editor, line, placement).withType(type).withResolved(resolved).withDefaultRenderer(doubleLine);
        if (paintFoldingOutline) {
            builder.withDefaultGutterRenderer(doubleLine);
        }
        List<RangeHighlighter> list2 = builder.done();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        List<RangeHighlighter> list2 = new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list2 = Collections.singletonList(marker);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        return list2;
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int line;
        private boolean resolved;
        @Nullable
        private TextDiffType type;
        @Nullable
        private LineSeparatorRenderer renderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "<init>"));
            }
            if (placement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "<init>"));
            }
            this.resolved = false;
            this.editor = editor;
            this.line = line;
            this.placement = placement;
        }

        @NotNull
        public LineMarkerBuilder withType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withType"));
            }
            this.type = type;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withType"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withResolved"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@NotNull LineSeparatorRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withRenderer"));
            }
            this.renderer = renderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withRenderer"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, this.type, this.placement, doubleLine, this.resolved);
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withDefaultRenderer"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.gutterRenderer = DiffDrawUtil.createFoldingGutterLineRenderer(this.type, this.placement, doubleLine, this.resolved);
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withDefaultGutterRenderer"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.editor.getDocument(), this.line);
            RangeHighlighter highlighter2 = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
            highlighter2.setLineSeparatorPlacement(this.placement);
            highlighter2.setLineSeparatorRenderer(this.renderer);
            highlighter2.setLineMarkerRenderer(this.gutterRenderer);
            if (this.type == null || this.resolved) {
                List<RangeHighlighter> list2 = Collections.singletonList(highlighter2);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "done"));
                }
                return list2;
            }
            TextAttributes stripeAttributes = DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List list3 = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter2, stripeHighlighter});
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "done"));
            }
            return list3;
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "<init>"));
            }
            this.editor = editor;
            this.type = type;
            this.start = start2;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, false);
            RangeHighlighter highlighter2 = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5998, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter2, this.type);
            }
            List<RangeHighlighter> list2 = Collections.singletonList(highlighter2);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "done"));
            }
            return list2;
        }
    }

    private static class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored;
        private boolean resolved;
        private boolean hideWithoutLineNumbers;

        private LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "<init>"));
            }
            this.ignored = false;
            this.resolved = false;
            this.hideWithoutLineNumbers = false;
            this.editor = editor;
            this.type = type;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "withIgnored"));
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "withResolved"));
            }
            return lineHighlighterBuilder;
        }

        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            return this;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start2 = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            TextAttributes attributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, this.ignored);
            TextAttributes stripeAttributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter highlighter2 = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 5997, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter2);
            highlighter2.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter2, this.type, this.ignored, this.resolved, this.hideWithoutLineNumbers, isEmptyRange, isLastLine));
            if (isEmptyRange) {
                if (this.startLine == 0) {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, 0, this.type, SeparatorPlacement.TOP, true, this.resolved, false));
                } else {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine - 1, this.type, SeparatorPlacement.BOTTOM, true, this.resolved, false));
                }
            } else if (this.resolved) {
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine, this.type, SeparatorPlacement.TOP, false, this.resolved, false));
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.endLine - 1, this.type, SeparatorPlacement.BOTTOM, false, this.resolved, false));
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            ArrayList<RangeHighlighter> arrayList = highlighters;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "done"));
            }
            return arrayList;
        }
    }
}

