/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DiffEmptyHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final TextDiffType myDiffType;

    public DiffEmptyHighlighterRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/diff/util/DiffEmptyHighlighterRenderer", "<init>"));
        }
        this.myDiffType = diffType;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter2, @NotNull Graphics g2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffEmptyHighlighterRenderer", "paint"));
        }
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffEmptyHighlighterRenderer", "paint"));
        }
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffEmptyHighlighterRenderer", "paint"));
        }
        g2.setColor(this.myDiffType.getColor(editor));
        Point point = editor.logicalPositionToXY(editor.offsetToLogicalPosition(highlighter2.getStartOffset()));
        int endy = point.y + editor.getLineHeight() - 1;
        g2.drawLine(point.x, point.y, point.x, endy);
        g2.drawLine(point.x - 1, point.y, point.x - 1, endy);
    }
}

