/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DiffPsiFileSupport;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    public static final Key<Boolean> TEMP_FILE_KEY = Key.create((String)"Diff.TempFile");
    @NotNull
    public static final String DIFF_CONFIG = "diff.xml";
    public static final int TITLE_GAP = JBUI.scale((int)2);

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isDiffEditor"));
        }
        return editor.getUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY) != null;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content2, @NotNull CharSequence text2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        EditorHighlighter highlighter2 = DiffUtil.createEditorHighlighter(project2, content2);
        if (highlighter2 == null) {
            return null;
        }
        highlighter2.setText(text2);
        return highlighter2;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        EditorHighlighter highlighter2 = DiffUtil.createEmptyEditorHighlighter();
        highlighter2.setText(text2);
        EditorHighlighter editorHighlighter = highlighter2;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    private static EditorHighlighter createEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createEditorHighlighter"));
        }
        FileType type = content2.getContentType();
        VirtualFile file2 = content2.getHighlightFile();
        Language language = (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && file2.isValid() && (type == null || type == PlainTextFileType.INSTANCE || file2.getFileType() == type || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project2, file2);
        }
        if (type != null) {
            return highlighterFactory.createEditorHighlighter(project2, type);
        }
        return null;
    }

    @NotNull
    private static EditorHighlighter createEmptyEditorHighlighter() {
        EmptyEditorHighlighter emptyEditorHighlighter = new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        if (emptyEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEmptyEditorHighlighter"));
        }
        return emptyEditorHighlighter;
    }

    public static void setEditorHighlighter(@Nullable Project project2, @NotNull EditorEx editor, @NotNull DocumentContent content2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        EditorHighlighter highlighter2 = DiffUtil.createEditorHighlighter(project2, content2);
        if (highlighter2 != null) {
            editor.setHighlighter(highlighter2);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project2, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorCodeStyle"));
        }
        if (project2 != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project2);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setFoldingModelSupport"));
        }
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project2, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorEx editorEx = DiffUtil.createEditor(document, project2, isViewer, false);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project2, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorFactory factory2 = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory2.createViewer(document, project2) : factory2.createEditor(document, project2));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content2, @Nullable Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        DiffUtil.setEditorHighlighter(project2, editor, content2);
        DiffUtil.setEditorCodeStyle(project2, editor, content2.getContentType());
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(content2.getDocument());
        if (virtualFile != null && Registry.is((String)"diff.enable.psi.highlighting")) {
            editor.setFile(virtualFile);
        }
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isMirrored"));
        }
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 == null || project2.isDefault()) {
            return false;
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        if (DiffPsiFileSupport.isDiffFile(file2)) {
            return false;
        }
        return file2.getUserData(TEMP_FILE_KEY) != Boolean.TRUE;
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "disableBlitting"));
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "scrollToPoint"));
        }
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            Point point = new Point(0, 0);
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
            }
            return point;
        }
        ScrollingModel model2 = editor.getScrollingModel();
        Point point = new Point(model2.getHorizontalScrollOffset(), model2.getVerticalScrollOffset());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
        }
        return point;
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCaretPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        return icon;
    }

    public static void registerAction(@NotNull AnAction action2, @NotNull JComponent component) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        String text2 = StringUtil.replace((String)message2, (String)"\n", (String)"<br>");
        JBLabel label = new JBLabel(text2){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        label.setForeground(UIUtil.getInactiveTextColor());
        CenteredPanel centeredPanel = new CenteredPanel((JComponent)label, JBUI.Borders.empty((int)5));
        if (centeredPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return centeredPanel;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions2) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        DiffUtil.addActionBlock(group, Arrays.asList(actions2));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions2) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions2 == null || actions2.isEmpty()) {
            return;
        }
        group.addSeparator();
        Object[] children2 = group.getChildren(null);
        for (AnAction anAction : actions2) {
            if (!(anAction instanceof Separator) && ArrayUtil.contains((Object)anAction, (Object[])children2)) continue;
            group.add(anAction);
        }
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        if ("Settings | Tools | Diff" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSettingsConfigurablePath"));
        }
        return "Settings | Tools | Diff";
    }

    @NotNull
    public static String createTooltipText(@NotNull String text2, @Nullable String appendix) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text2);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        String string2 = result2.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        return string2;
    }

    @NotNull
    public static String createNotificationText(@NotNull String text2, @Nullable String appendix) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text2);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        String string2 = result2.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        return string2;
    }

    public static void showSuccessPopup(@NotNull String message2, @NotNull RelativePoint point, @NotNull Disposable disposable, final @Nullable Runnable hyperlinkHandler) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/util/DiffUtil", "showSuccessPopup"));
        }
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e2) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable, (Disposable)balloon);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        List contents = request2.getContents();
        List titles = request2.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list2 = Collections.nCopies(titles.size(), null);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
            }
            return list2;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            components.add(title);
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request2, @NotNull List<? extends Editor> editors) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        List contents = request2.getContents();
        List titles = request2.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list2 = Collections.nCopies(titles.size(), null);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
            }
            return list2;
        }
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))), (DiffContent)contents.get(i2), equalCharsets, equalSeparators, editors.get(i2));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            result2.add(title);
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        return arrayList;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable JComponent title, @NotNull DiffContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitleWithNotifications"));
        }
        List<JComponent> notifications = DiffUtil.getCustomNotifications(content2);
        if (notifications.isEmpty()) {
            return title;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (title != null) {
            components.add(title);
        }
        components.addAll(notifications);
        return DiffUtil.createStackedComponents(components, TITLE_GAP);
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content2, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content2 instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content2;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, separator, charset, bom, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        JComponent jComponent = DiffUtil.createTitle(title, null, null, null, false);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (readOnly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        panel2.add((Component)new JBLabel(title).setCopyable(true), "Center");
        if (charset != null && separator != null) {
            JPanel panel22 = new JPanel();
            panel22.setLayout(new BoxLayout(panel22, 0));
            panel22.add(DiffUtil.createCharsetPanel(charset, bom));
            panel22.add(Box.createRigidArea(new Dimension(4, 0)));
            panel22.add(DiffUtil.createSeparatorPanel(separator));
            panel2.add((Component)panel22, "East");
        } else if (charset != null) {
            panel2.add((Component)DiffUtil.createCharsetPanel(charset, bom), "East");
        } else if (separator != null) {
            panel2.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        String text2 = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text2 = text2 + " BOM";
        }
        JLabel label = new JLabel(text2);
        if (charset.equals(Charset.forName("UTF-8"))) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        JLabel label = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        if (!ContainerUtil.exists(components, (Condition)Condition.NOT_NULL)) {
            List<JComponent> list2 = components;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
            }
            return list2;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i2 = 0; i2 < components.size(); ++i2) {
            result2.add(new SyncHeightComponent(components, i2));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        return arrayList;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<JComponent> components, int gap) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil", "createStackedComponents"));
        }
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        for (int i2 = 0; i2 < components.size(); ++i2) {
            if (i2 != 0) {
                panel2.add(Box.createVerticalStrut(JBUI.scale((int)gap)));
            }
            panel2.add(components.get(i2));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createStackedComponents"));
        }
        return jPanel;
    }

    public static boolean isFocusedComponent(@Nullable Component component) {
        return DiffUtil.isFocusedComponent(null, component);
    }

    public static boolean isFocusedComponent(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        return IdeFocusManager.getInstance((Project)project2).getFocusedDescendantFor(component) != null;
    }

    public static void requestFocus(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project2).requestFocus(component, true);
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project2, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
        }
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            SimpleTextDiffProvider simpleTextDiffProvider = new SimpleTextDiffProvider(settings, rediff, disposable, diffComputer);
            if (simpleTextDiffProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
            }
            return simpleTextDiffProvider;
        }
        TwosideTextDiffProvider smartProvider = SmartTextDiffProvider.create(project2, request2, settings, rediff, disposable);
        if (smartProvider != null) {
            TwosideTextDiffProvider twosideTextDiffProvider = smartProvider;
            if (twosideTextDiffProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
            }
            return twosideTextDiffProvider;
        }
        SimpleTextDiffProvider simpleTextDiffProvider = new SimpleTextDiffProvider(settings, rediff, disposable);
        if (simpleTextDiffProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextDiffProvider"));
        }
        return simpleTextDiffProvider;
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project2, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
        }
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            SimpleTextDiffProvider.NoIgnore noIgnore = new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable, diffComputer);
            if (noIgnore == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
            }
            return noIgnore;
        }
        TwosideTextDiffProvider.NoIgnore smartProvider = SmartTextDiffProvider.createNoIgnore(project2, request2, settings, rediff, disposable);
        if (smartProvider != null) {
            TwosideTextDiffProvider.NoIgnore noIgnore = smartProvider;
            if (noIgnore == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
            }
            return noIgnore;
        }
        SimpleTextDiffProvider.NoIgnore noIgnore = new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable);
        if (noIgnore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNoIgnoreTextDiffProvider"));
        }
        return noIgnore;
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "isChunksEquals"));
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonManager.getInstance().isEquals(chunk1, chunk2, comparisonPolicy);
    }

    @NotNull
    public static <T> int[] getSortedIndexes(@NotNull List<T> values, @NotNull Comparator<T> comparator2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(values.size());
        for (int i3 = 0; i3 < values.size(); ++i3) {
            indexes.add(i3);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/diff/util/DiffUtil", "lambda$getSortedIndexes$3"));
            }
            if (comparator2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/diff/util/DiffUtil", "lambda$getSortedIndexes$3"));
            }
            Object val1 = values.get((int)i1);
            Object val2 = values.get((int)i2);
            return comparator2.compare(val1, val2);
        });
        int[] nArray = ArrayUtil.toIntArray(indexes);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSortedIndexes"));
        }
        return nArray;
    }

    @NotNull
    public static int[] invertIndexes(@NotNull int[] indexes) {
        if (indexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexes", "com/intellij/diff/util/DiffUtil", "invertIndexes"));
        }
        int[] inverted = new int[indexes.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            inverted[indexes[i2]] = i2;
        }
        if (inverted == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "invertIndexes"));
        }
        return inverted;
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret.getSelectionEnd() != document.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret.getLogicalPosition().line);
            if (caret.getOffset() != document.getTextLength()) continue;
            lines.set(totalLines);
        }
        BitSet bitSet = lines;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        return bitSet;
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/diff/util/DiffUtil", "isSelectedByLine"));
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "deleteLines"));
        }
        TextRange range = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text2));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text2 + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text2);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (newLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLines", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        if (lineOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        assert (sequence.length() == lineOffsets.getTextLength());
        CharSequence charSequence = DiffUtil.getLinesRange(lineOffsets, line1, line2, false).subSequence(sequence);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < DiffUtil.getLineCount(document) ? document.getLineStartOffset(line1) : document.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
            }
            return textRange;
        }
        int startOffset = document.getLineStartOffset(line1);
        int endOffset = document.getLineEndOffset(line2 - 1);
        if (includeNewline && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (lineOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
            }
            return textRange;
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return textRange;
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getOffset"));
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start2 + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        List<String> list2 = DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        return list2;
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        if (startLine < 0 || startLine > endLine || endLine > DiffUtil.getLineCount(document)) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, document.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = startLine; i2 < endLine; ++i2) {
            int start2 = document.getLineStartOffset(i2);
            int end = document.getLineEndOffset(i2);
            result2.add(document.getText(new TextRange(start2, end)));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLines"));
        }
        return arrayList;
    }

    public static int bound(int value2, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value2, lowerBound, upperBound);
        return Math.max(Math.min(value2, upperBound), lowerBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/util/DiffUtil", "getAffectedLineRange"));
        }
        int line1 = e2.getDocument().getLineNumber(e2.getOffset());
        int line2 = e2.getDocument().getLineNumber(e2.getOffset() + e2.getOldLength()) + 1;
        LineRange lineRange = new LineRange(line1, line2);
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getAffectedLineRange"));
        }
        return lineRange;
    }

    public static int countLinesShift(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/util/DiffUtil", "countLinesShift"));
        }
        return StringUtil.countNewLines((CharSequence)e2.getNewFragment()) - StringUtil.countNewLines((CharSequence)e2.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift) {
        UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(start2, end, changeStart, changeEnd, shift, false);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start2, end, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start2 >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start2 + shift, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start2 <= changeStart && end >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start2, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        int newChangeEnd = changeEnd + shift;
        if (start2 >= changeStart && end <= changeEnd) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start2 < changeStart) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(start2, newChangeEnd, true) : new UpdatedLineRange(start2, changeStart, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        if (hasDeleted) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        if (hasInserted) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
            }
            return textDiffType;
        }
        LOG.error("Diff fragment should not be empty");
        TextDiffType textDiffType = TextDiffType.MODIFIED;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<ThreeSide> emptiness, @NotNull Equality<ThreeSide> equality) {
        if (emptiness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptiness", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        if (equality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, false, true);
                if (mergeConflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
                }
                return mergeConflictType;
            }
            if (isRightEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, true, false);
                if (mergeConflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
                }
                return mergeConflictType;
            }
            boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            MergeConflictType mergeConflictType = new MergeConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.DELETED);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        boolean unchangedLeft = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            MergeConflictType mergeConflictType = new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        if (unchangedRight) {
            MergeConflictType mergeConflictType = new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (mergeConflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
            }
            return mergeConflictType;
        }
        boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        MergeConflictType mergeConflictType = new MergeConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getMergeType"));
        }
        return mergeConflictType;
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        if (sequences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        if (lineOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        MergeConflictType mergeConflictType = DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$4"));
            }
            return DiffUtil.isLineMergeIntervalEmpty(fragment, side);
        }), (Equality<ThreeSide>)((Equality)(side1, side2) -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            if (sequences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            if (lineOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "lambda$getLineMergeType$5"));
            }
            return DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2);
        }));
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineMergeType"));
        }
        return mergeConflictType;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (sequences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (lineOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/util/DiffUtil", "compareLineMergeContents"));
        }
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = (CharSequence)side1.select(sequences);
        CharSequence sequence2 = (CharSequence)side2.select(sequences);
        LineOffsets offsets1 = (LineOffsets)side1.select(lineOffsets);
        LineOffsets offsets2 = (LineOffsets)side2.select(lineOffsets);
        for (int i2 = 0; i2 < end1 - start1; ++i2) {
            int line1 = start1 + i2;
            int line2 = start2 + i2;
            CharSequence content1 = DiffUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            CharSequence content2 = DiffUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1);
            if (ComparisonManager.getInstance().isEquals(content1, content2, policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "isLineMergeIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/DiffUtil", "isLineMergeIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getWordMergeType"));
        }
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/diff/util/DiffUtil", "getWordMergeType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "getWordMergeType"));
        }
        MergeConflictType mergeConflictType = DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getWordMergeType$6"));
            }
            return DiffUtil.isWordMergeIntervalEmpty(fragment, side);
        }), (Equality<ThreeSide>)((Equality)(side1, side2) -> {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "lambda$getWordMergeType$7"));
            }
            if (texts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/diff/util/DiffUtil", "lambda$getWordMergeType$7"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "lambda$getWordMergeType$7"));
            }
            return DiffUtil.compareWordMergeContents(fragment, texts, policy, side1, side2);
        }));
        if (mergeConflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getWordMergeType"));
        }
        return mergeConflictType;
    }

    private static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "compareWordMergeContents"));
        }
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/diff/util/DiffUtil", "compareWordMergeContents"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil", "compareWordMergeContents"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/util/DiffUtil", "compareWordMergeContents"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/util/DiffUtil", "compareWordMergeContents"));
        }
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = (CharSequence)side1.select(texts);
        CharSequence document2 = (CharSequence)side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEquals(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "isWordMergeIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/DiffUtil", "isWordMergeIntervalEmpty"));
        }
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    public static boolean executeWriteCommand(@Nullable Project project2, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (!DiffUtil.makeWritable(project2, document)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$9"));
            }
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$9"));
            }
            if (confirmationPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil", "lambda$executeWriteCommand$9"));
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "lambda$null$8"));
                }
                if (task2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "lambda$null$8"));
                }
                if (underBulkUpdate) {
                    DocumentUtil.executeInBulk(document, true, task2);
                } else {
                    task2.run();
                }
            }, commandName, (Object)commandGroupId, confirmationPolicy, document);
        });
        return true;
    }

    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project2, @Nullable String commandName, @NotNull Runnable task2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        return DiffUtil.executeWriteCommand(project2, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task2);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isEditable"));
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "canMakeWritable"));
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            if (file2.getUserData(TEMP_FILE_KEY) == Boolean.TRUE) {
                return false;
            }
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return document.isWritable();
        }
        return DiffUtil.makeWritable(project2, file2) && document.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project2, @NotNull Document document) {
        UndoManager undoManager;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "putNonundoableOperation"));
        }
        UndoManager undoManager2 = undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/diff/util/DiffUtil", "markDirtyAndRefresh"));
        }
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files2);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files2);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        Dimension dimension = new Dimension(400, 200);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffPanelSize"));
        }
        return dimension;
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffWindowSize"));
        }
        return dimension;
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        WindowWrapper.Mode mode = hints.getMode();
        if (mode == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null && (!(component instanceof Window) || (isClosed = DiffUtil.closeWindow(component, modalOnly)))) {
            component = recursive ? component.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/diff/util/DiffUtil", "closeWindow"));
        }
        if (window instanceof IdeFrameImpl) {
            return false;
        }
        if (modalOnly && window instanceof Frame) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "createUserDataHolder"));
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value2);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "isUserDataFlagSet"));
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "getUserData"));
        }
        if (first != null && (data = first.getUserData(key)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@Nullable JComponent component, @NotNull UserDataHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "addNotification"));
        }
        if (component == null) {
            return;
        }
        List oldComponents = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)oldComponents, (Object[])new JComponent[]{component}));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        List requestComponents = (List)request2.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context2.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List list2 = ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        return list2;
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        List list2 = ContainerUtil.notNullize((List)((List)content2.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        return list2;
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider, @Nullable DataProvider fallbackProvider, @NonNls String dataId) {
        Object data;
        if (provider != null && (data = provider.getData(dataId)) != null) {
            return data;
        }
        if (fallbackProvider != null && (data = fallbackProvider.getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value2) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        DataProvider dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER);
        if (!(dataProvider instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value2);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/util/DiffUtil", "getDiffSettings"));
        }
        DiffSettingsHolder.DiffSettings settings = (DiffSettingsHolder.DiffSettings)context2.getUserData(DiffSettingsHolder.DiffSettings.KEY);
        if (settings == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context2.getUserData(DiffUserDataKeys.PLACE));
            context2.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        DiffSettingsHolder.DiffSettings diffSettings = settings;
        if (diffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffSettings"));
        }
        return diffSettings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map2, @NotNull Convertor<K, V> defaultValue) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/diff/util/DiffUtil", "trimDefaultValues"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/diff/util/DiffUtil", "trimDefaultValues"));
        }
        TreeMap<K, V> result2 = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map2.entrySet()) {
            K key = it.getKey();
            V value2 = it.getValue();
            if (value2.equals(defaultValue.convert(key))) continue;
            result2.put(key, value2);
        }
        TreeMap<K, V> treeMap = result2;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "trimDefaultValues"));
        }
        return treeMap;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        if (tools.size() < 2) {
            List list2 = tools;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list2;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e2) {
                LOG.error(e2);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list3 = tools;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list3;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        List list4 = filteredTools.isEmpty() ? tools : filteredTools;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        return list4;
    }

    public static class CenteredPanel
    extends JPanel {
        private final JComponent myComponent;

        public CenteredPanel(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            this.myComponent = component;
            this.add(component);
        }

        public CenteredPanel(@NotNull JComponent component, @NotNull Border border) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            if (border == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "border", "com/intellij/diff/util/DiffUtil$CenteredPanel", "<init>"));
            }
            this(component);
            this.setBorder(border);
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            Insets insets = this.getInsets();
            JBInsets.removeFrom((Dimension)size, (Insets)insets);
            int width = Math.min(size.width, preferredSize.width);
            int height = Math.min(size.height, preferredSize.height);
            int x2 = Math.max(0, (size.width - preferredSize.width) / 2);
            int y2 = Math.max(0, (size.height - preferredSize.height) / 2);
            this.myComponent.setBounds(insets.left + x2, insets.top + y2, width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myComponent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myComponent.getMinimumSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.addInsets(this.myComponent.getMaximumSize());
        }

        private Dimension addInsets(Dimension dimension) {
            JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
            return dimension;
        }
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<JComponent> myComponents;

        public SyncHeightComponent(@NotNull List<JComponent> components, int index) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil$SyncHeightComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate2 = components.get(index);
            if (delegate2 != null) {
                this.add((Component)delegate2, "Center");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getPreferredHeight();
            return size;
        }

        private int getPreferredHeight() {
            int height = 0;
            for (JComponent component : this.myComponents) {
                if (component == null) continue;
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

