/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AmendComponent {
    private static final Logger LOG = Logger.getInstance(AmendComponent.class);
    @NotNull
    private final RepositoryManager<? extends Repository> myRepoManager;
    @NotNull
    private final CheckinProjectPanel myCheckinPanel;
    @NotNull
    private final JCheckBox myAmend;
    @NotNull
    private final String myPreviousMessage;
    @Nullable
    private Map<VirtualFile, String> myMessagesForRoots;
    @Nullable
    private String myAmendedMessage;

    public AmendComponent(@NotNull Project project2, @NotNull RepositoryManager<? extends Repository> repoManager, @NotNull CheckinProjectPanel panel2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        if (repoManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoManager", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        this(project2, repoManager, panel2, DvcsBundle.message("commit.amend", new Object[0]));
    }

    public AmendComponent(final @NotNull Project project2, @NotNull RepositoryManager<? extends Repository> repoManager, @NotNull CheckinProjectPanel panel2, @NotNull String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        if (repoManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoManager", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/dvcs/AmendComponent", "<init>"));
        }
        this.myRepoManager = repoManager;
        this.myCheckinPanel = panel2;
        this.myAmend = new NonFocusableCheckBox(title);
        this.myAmend.setMnemonic('m');
        this.myAmend.setToolTipText(DvcsBundle.message("commit.amend.tooltip", new Object[0]));
        this.myPreviousMessage = this.myCheckinPanel.getCommitMessage();
        this.myAmend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (AmendComponent.this.myAmend.isSelected()) {
                    if (AmendComponent.this.myPreviousMessage.equals(AmendComponent.this.myCheckinPanel.getCommitMessage())) {
                        String message2;
                        if (AmendComponent.this.myMessagesForRoots == null) {
                            AmendComponent.this.loadMessagesInModalTask(project2);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)(message2 = AmendComponent.this.constructAmendedMessage()))) {
                            AmendComponent.this.myAmendedMessage = message2;
                            AmendComponent.this.substituteCommitMessage(AmendComponent.this.myAmendedMessage);
                        }
                    }
                } else if (AmendComponent.this.myCheckinPanel.getCommitMessage().equals(AmendComponent.this.myAmendedMessage)) {
                    AmendComponent.this.myCheckinPanel.setCommitMessage(AmendComponent.this.myPreviousMessage);
                }
            }
        });
    }

    @Nullable
    private String constructAmendedMessage() {
        Set<VirtualFile> selectedRoots = this.getVcsRoots(this.getSelectedFilePaths());
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        if (this.myMessagesForRoots != null) {
            for (VirtualFile root : selectedRoots) {
                String message2 = this.myMessagesForRoots.get(root);
                if (message2 == null) continue;
                messages.add(message2);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    public void refresh() {
        this.myAmend.setSelected(false);
    }

    @NotNull
    public Component getComponent() {
        JCheckBox jCheckBox = this.myAmend;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/AmendComponent", "getComponent"));
        }
        return jCheckBox;
    }

    @NotNull
    public JCheckBox getCheckBox() {
        JCheckBox jCheckBox = this.myAmend;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/AmendComponent", "getCheckBox"));
        }
        return jCheckBox;
    }

    private void loadMessagesInModalTask(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/AmendComponent", "loadMessagesInModalTask"));
        }
        try {
            this.myMessagesForRoots = (Map)ProgressManager.getInstance().runProcessWithProgressSynchronously(this::getLastCommitMessages, "Reading Commit Message...", true, project2);
        }
        catch (VcsException e2) {
            Messages.showErrorDialog((Project)project2, (String)("Couldn't load commit message of the commit to amend.\n" + e2.getMessage()), (String)"Commit Message not Loaded");
            LOG.info((Throwable)e2);
        }
    }

    private void substituteCommitMessage(@NotNull String newMessage) {
        if (newMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMessage", "com/intellij/dvcs/AmendComponent", "substituteCommitMessage"));
        }
        if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.myPreviousMessage, (CharSequence)newMessage)) {
            VcsConfiguration.getInstance((Project)this.myCheckinPanel.getProject()).saveCommitMessage(this.myPreviousMessage);
            this.myCheckinPanel.setCommitMessage(newMessage);
        }
    }

    @Nullable
    private Map<VirtualFile, String> getLastCommitMessages() throws VcsException {
        HashMap<VirtualFile, String> messagesForRoots = new HashMap<VirtualFile, String>();
        for (VirtualFile root : this.getAffectedRoots()) {
            String message2 = this.getLastCommitMessage(root);
            messagesForRoots.put(root, message2);
        }
        return messagesForRoots;
    }

    @NotNull
    protected Collection<VirtualFile> getAffectedRoots() {
        Collection collection = this.myRepoManager.getRepositories().stream().filter(repo -> !repo.isFresh()).map(Repository::getRoot).filter(root -> this.myCheckinPanel.getRoots().contains(root)).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/AmendComponent", "getAffectedRoots"));
        }
        return collection;
    }

    @NotNull
    private List<FilePath> getSelectedFilePaths() {
        List list2 = ContainerUtil.map((Collection)this.myCheckinPanel.getFiles(), VcsUtil::getFilePath);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/AmendComponent", "getSelectedFilePaths"));
        }
        return list2;
    }

    @NotNull
    protected abstract Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> var1);

    @Nullable
    protected abstract String getLastCommitMessage(@NotNull VirtualFile var1) throws VcsException;

    public boolean isAmend() {
        return this.myAmend.isSelected();
    }
}

