/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/VcsPushAction", "actionPerformed"));
        }
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        VcsRepositoryManager manager = VcsRepositoryManager.getInstance(project2);
        List repositories = e2.getData(CommonDataKeys.EDITOR) != null ? ContainerUtil.emptyList() : VcsPushAction.collectRepositories(manager, (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        VirtualFile selectedFile = DvcsUtil.getSelectedFile(project2);
        new VcsPushDialog(project2, DvcsUtil.sortRepositories(repositories), selectedFile != null ? manager.getRepositoryForFile(selectedFile) : null).show();
    }

    @NotNull
    private static Collection<Repository> collectRepositories(@NotNull VcsRepositoryManager vcsRepositoryManager, @Nullable VirtualFile[] files2) {
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "com/intellij/dvcs/push/VcsPushAction", "collectRepositories"));
        }
        if (files2 == null) {
            List<Repository> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/VcsPushAction", "collectRepositories"));
            }
            return list2;
        }
        HashSet repositories = ContainerUtil.newHashSet();
        for (VirtualFile file2 : files2) {
            Repository repo = vcsRepositoryManager.getRepositoryForFile(file2);
            if (repo == null) continue;
            repositories.add(repo);
        }
        HashSet hashSet = repositories;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/VcsPushAction", "collectRepositories"));
        }
        return hashSet;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/VcsPushAction", "update"));
        }
        super.update(e2);
        Project project2 = e2.getProject();
        e2.getPresentation().setEnabledAndVisible(project2 != null && !VcsRepositoryManager.getInstance(project2).getRepositories().isEmpty());
    }
}

