/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.CheckboxTree;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBranchEditorListener
extends LinkMouseListenerBase {
    private static final Logger LOG = Logger.getInstance(VcsBranchEditorListener.class);
    private final CheckboxTree.CheckboxTreeCellRenderer myRenderer;
    private VcsLinkedTextComponent myUnderlined;

    public VcsBranchEditorListener(CheckboxTree.CheckboxTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        Component component = (Component)e2.getSource();
        Object tag = this.getTagAt(e2);
        boolean shouldRepaint = false;
        if (this.myUnderlined != null) {
            this.myUnderlined.setUnderlined(false);
            this.myUnderlined = null;
            shouldRepaint = true;
        }
        if (tag instanceof VcsLinkedTextComponent) {
            component.setCursor(Cursor.getPredefinedCursor(12));
            VcsLinkedTextComponent linkedText = (VcsLinkedTextComponent)tag;
            linkedText.setUnderlined(true);
            this.myUnderlined = linkedText;
            shouldRepaint = true;
        } else {
            super.mouseMoved(e2);
        }
        if (shouldRepaint) {
            this.myRenderer.getTextRenderer().getTree().repaint();
        }
    }

    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/ui/VcsBranchEditorListener", "getTagAt"));
        }
        return PushLogTreeUtil.getTagAtForRenderer(this.myRenderer, e2);
    }

    protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/push/ui/VcsBranchEditorListener", "handleTagClick"));
        }
        if (tag instanceof VcsLinkedTextComponent) {
            VcsLinkedTextComponent textWithLink = (VcsLinkedTextComponent)tag;
            TreePath path = this.myRenderer.getTextRenderer().getTree().getPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            if (node == null || !(node instanceof DefaultMutableTreeNode)) {
                LOG.warn("Incorrect last path component: " + node);
                return;
            }
            textWithLink.fireOnClick((DefaultMutableTreeNode)node, event);
        }
        if (tag instanceof Runnable) {
            ((Runnable)tag).run();
        }
    }
}

