/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RepositoryImpl
implements Repository {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRootDir;
    @NotNull
    protected volatile Repository.State myState;
    @Nullable
    protected volatile String myCurrentRevision;

    protected RepositoryImpl(@NotNull Project project2, @NotNull VirtualFile dir, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/dvcs/repo/RepositoryImpl", "<init>"));
        }
        this.myProject = project2;
        this.myRootDir = dir;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public String getPresentableUrl() {
        String string2 = this.getRoot().getPresentableUrl();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getPresentableUrl"));
        }
        return string2;
    }

    public String toString() {
        return this.getPresentableUrl();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getProject"));
        }
        return project2;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryImpl", "getState"));
        }
        return state;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public void dispose() {
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Repository that = (Repository)o2;
        if (!this.getProject().equals(that.getProject())) {
            return false;
        }
        return this.getRoot().equals(that.getRoot());
    }

    public int hashCode() {
        int result2 = this.getProject().hashCode();
        result2 = 31 * result2 + this.getRoot().hashCode();
        return result2;
    }
}

