/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.EmptyIcon;
import icons.DvcsImplIcons;
import javax.swing.Icon;

public abstract class BranchActionGroup
extends ActionGroup
implements DumbAware {
    private boolean myIsFavorite;
    private final LayeredIcon myIcon = new LayeredIcon(new Icon[]{DvcsImplIcons.Favorite, EmptyIcon.ICON_16});
    private final LayeredIcon myHoveredIcon = new LayeredIcon(new Icon[]{DvcsImplIcons.FavoriteOnHover, DvcsImplIcons.NotFavoriteOnHover});

    public BranchActionGroup() {
        super("", true);
        this.getTemplatePresentation().setIcon((Icon)this.myIcon);
        this.getTemplatePresentation().setHoveredIcon((Icon)this.myHoveredIcon);
        this.updateIcons();
    }

    private void updateIcons() {
        this.myIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
    }

    public boolean isFavorite() {
        return this.myIsFavorite;
    }

    public void setFavorite(boolean favorite) {
        this.myIsFavorite = favorite;
        this.updateIcons();
    }

    public void toggle() {
        this.setFavorite(!this.myIsFavorite);
    }
}

