/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloneDvcsDialog
extends DialogWrapper {
    private static final Pattern SSH_URL_PATTERN;
    private JPanel myRootPanel;
    private EditorComboBox myRepositoryURL;
    private TextFieldWithBrowseButton myParentDirectory;
    private JButton myTestButton;
    private JTextField myDirectoryName;
    private JLabel myRepositoryUrlLabel;
    @NotNull
    private String myTestURL;
    @Nullable
    private Boolean myTestResult;
    @NotNull
    private String myDefaultDirectoryName;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private final String myDefaultRepoUrl;

    public CloneDvcsDialog(@NotNull Project project2, @NotNull String displayName, @NotNull String vcsDirectoryName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (vcsDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirectoryName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        this(project2, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project2, @NotNull String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (vcsDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirectoryName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        super(project2, true);
        this.myDefaultDirectoryName = "";
        this.myDefaultRepoUrl = defaultUrl;
        this.myProject = project2;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.$$$setupUI$$$();
        this.init();
        this.initListeners();
        this.setTitle(DvcsBundle.getString("clone.title"));
        this.myRepositoryUrlLabel.setText(DvcsBundle.message("clone.repository.url", displayName));
        this.myRepositoryUrlLabel.setDisplayedMnemonic('R');
        this.setOKButtonText(DvcsBundle.getString("clone.button"));
        FrameStateManager.getInstance().addListener((FrameStateListener)new FrameStateListener.Adapter(){

            public void onFrameActivated() {
                CloneDvcsDialog.this.updateButtons();
            }
        }, this.getDisposable());
    }

    protected void doOKAction() {
        File parent = new File(this.getParentDirectory());
        if (parent.exists() && parent.isDirectory() && parent.canWrite() || parent.mkdirs()) {
            super.doOKAction();
            return;
        }
        this.setErrorText("Couldn't create " + parent + "<br/>Check your access rights", (JComponent)this.myParentDirectory);
        this.setOKActionEnabled(false);
    }

    @NotNull
    public String getSourceRepositoryURL() {
        String string2 = this.getCurrentUrlText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "getSourceRepositoryURL"));
        }
        return string2;
    }

    public String getParentDirectory() {
        return this.myParentDirectory.getText();
    }

    public String getDirectoryName() {
        return this.myDirectoryName.getText();
    }

    private void initListeners() {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(DvcsBundle.getString("clone.destination.directory.title"));
        fcd.setDescription(DvcsBundle.getString("clone.destination.directory.description"));
        fcd.setHideIgnored(false);
        this.myParentDirectory.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(fcd.getTitle(), fcd.getDescription(), (ComponentWithBrowseButton)this.myParentDirectory, this.myProject, fcd, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file2;
                String text2 = this.getComponentText();
                if (text2.length() == 0 && (file2 = CloneDvcsDialog.this.myProject.getBaseDir()) != null) {
                    return file2;
                }
                return super.getInitialFile();
            }
        });
        com.intellij.ui.DocumentAdapter updateOkButtonListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e2) {
                CloneDvcsDialog.this.updateButtons();
            }
        };
        ((JTextField)this.myParentDirectory.getChildComponent()).getDocument().addDocumentListener((javax.swing.event.DocumentListener)updateOkButtonListener);
        String parentDir = this.getRememberedInputs().getCloneParentDir();
        if (StringUtil.isEmptyOrSpaces((String)parentDir)) {
            parentDir = ProjectUtil.getBaseDir();
        }
        this.myParentDirectory.setText(parentDir);
        this.myDirectoryName.getDocument().addDocumentListener((javax.swing.event.DocumentListener)updateOkButtonListener);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CloneDvcsDialog.this.test();
            }
        });
        this.setOKActionEnabled(false);
        this.myTestButton.setEnabled(false);
    }

    private void test() {
        this.myTestURL = this.getCurrentUrlText();
        TestResult testResult = (TestResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.test(this.myTestURL), DvcsBundle.message("clone.testing", this.myTestURL), true, this.myProject);
        if (testResult.isSuccess()) {
            Messages.showInfoMessage((Component)this.myTestButton, (String)DvcsBundle.message("clone.test.success.message", this.myTestURL), (String)DvcsBundle.getString("clone.test.connection.title"));
            this.myTestResult = Boolean.TRUE;
        } else {
            Messages.showErrorDialog((Project)this.myProject, (String)((String)ObjectUtils.assertNotNull((Object)testResult.getError())), (String)"Repository Test Failed");
            this.myTestResult = Boolean.FALSE;
        }
        this.updateButtons();
    }

    @NotNull
    protected abstract TestResult test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    private void updateButtons() {
        if (!this.checkRepositoryURL()) {
            return;
        }
        if (!this.checkDestination()) {
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private boolean checkDestination() {
        if (this.myParentDirectory.getText().length() == 0 || this.myDirectoryName.getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        File file2 = new File(this.myParentDirectory.getText(), this.myDirectoryName.getText());
        if (file2.exists() && !file2.isDirectory() || !ArrayUtil.isEmpty((Object[])file2.list())) {
            this.setErrorText(DvcsBundle.message("clone.destination.exists.error", file2), this.myDirectoryName);
            this.setOKActionEnabled(false);
            return false;
        }
        return true;
    }

    private boolean checkRepositoryURL() {
        String repository = this.getCurrentUrlText();
        if (repository.length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        if (this.myTestResult != null && repository.equals(this.myTestURL)) {
            if (!this.myTestResult.booleanValue()) {
                this.setErrorText(DvcsBundle.getString("clone.test.failed.error"), this.myRepositoryURL);
                this.setOKActionEnabled(false);
                return false;
            }
            return true;
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return true;
        }
        try {
            File file2 = new File(repository);
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    this.setErrorText(DvcsBundle.getString("clone.url.is.not.directory.error"), this.myRepositoryURL);
                    this.setOKActionEnabled(false);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setErrorText(DvcsBundle.getString("clone.invalid.url"), this.myRepositoryURL);
        this.setOKActionEnabled(false);
        return false;
    }

    @NotNull
    private String getCurrentUrlText() {
        String string2 = FileUtil.expandUserHome((String)this.myRepositoryURL.getText().trim());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "getCurrentUrlText"));
        }
        return string2;
    }

    private void createUIComponents() {
        this.myRepositoryURL = new EditorComboBox("");
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        ArrayList<String> urls = new ArrayList<String>(rememberedInputs.getVisitedUrls());
        if (this.myDefaultRepoUrl != null) {
            urls.add(0, this.myDefaultRepoUrl);
        }
        this.myRepositoryURL.setHistory((String[])ArrayUtil.toObjectArray(urls, String.class));
        this.myRepositoryURL.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e2) {
                String url = CloneDvcsDialog.this.getCurrentUrlText();
                CloneDvcsDialog.this.myTestButton.setEnabled(url.length() != 0);
                if (CloneDvcsDialog.this.myDefaultDirectoryName.equals(CloneDvcsDialog.this.myDirectoryName.getText()) || CloneDvcsDialog.this.myDirectoryName.getText().length() == 0) {
                    CloneDvcsDialog.this.myDefaultDirectoryName = CloneDvcsDialog.defaultDirectoryName(url, CloneDvcsDialog.this.myVcsDirectoryName);
                    CloneDvcsDialog.this.myDirectoryName.setText(CloneDvcsDialog.this.myDefaultDirectoryName);
                }
                CloneDvcsDialog.this.updateButtons();
            }
        });
    }

    public void prependToHistory(@NotNull String item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/dvcs/ui/CloneDvcsDialog", "prependToHistory"));
        }
        this.myRepositoryURL.prependItem(item);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private static String defaultDirectoryName(@NotNull String url, @NotNull String vcsDirName) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        if (vcsDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirName", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        String nonSystemName = url.endsWith("/" + vcsDirName) || url.endsWith(File.separator + vcsDirName) ? url.substring(0, url.length() - vcsDirName.length() - 1) : (url.endsWith(vcsDirName) ? url.substring(0, url.length() - vcsDirName.length()) : url);
        int i2 = nonSystemName.lastIndexOf(47);
        if (i2 == -1 && File.separatorChar != '/') {
            i2 = nonSystemName.lastIndexOf(File.separatorChar);
        }
        String string2 = i2 >= 0 ? nonSystemName.substring(i2 + 1) : "";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        return string2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryURL;
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all2 = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRepositoryUrlLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.repository.url"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        EditorComboBox editorComboBox = this.myRepositoryURL;
        jPanel.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.parent.dir"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.dir.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.test"));
        jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDirectoryName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(editorComboBox);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    protected static class TestResult {
        @NotNull
        public static final TestResult SUCCESS = new TestResult(null);
        @Nullable
        private final String myErrorMessage;

        public TestResult(@Nullable String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.myErrorMessage == null;
        }

        @Nullable
        public String getError() {
            return this.myErrorMessage;
        }
    }
}

