/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NewBranchAction<T extends Repository>
extends DumbAwareAction {
    protected final List<T> myRepositories;
    protected final Project myProject;

    public NewBranchAction(@NotNull Project project2, @NotNull List<T> repositories) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/NewBranchAction", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/ui/NewBranchAction", "<init>"));
        }
        super("New Branch", "Create and checkout new branch", AllIcons.General.Add);
        this.myRepositories = repositories;
        this.myProject = project2;
    }

    public void update(AnActionEvent e2) {
        if (DvcsUtil.anyRepositoryIsFresh(this.myRepositories)) {
            e2.getPresentation().setEnabled(false);
            e2.getPresentation().setDescription("Checkout of a new branch is not possible before the first commit");
        }
    }

    public abstract void actionPerformed(AnActionEvent var1);
}

