/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootAction<T extends Repository>
extends ActionGroup
implements PopupElementWithAdditionalInfo {
    @NotNull
    protected final T myRepository;
    @NotNull
    private final ActionGroup myGroup;
    @NotNull
    private final String myBranchText;

    public RootAction(@NotNull T repository, @Nullable T currentRepository, @NotNull ActionGroup actionsGroup, @NotNull String branchText) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/ui/RootAction", "<init>"));
        }
        if (actionsGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionsGroup", "com/intellij/dvcs/ui/RootAction", "<init>"));
        }
        if (branchText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchText", "com/intellij/dvcs/ui/RootAction", "<init>"));
        }
        super("", true);
        this.myRepository = repository;
        this.myGroup = actionsGroup;
        this.myBranchText = branchText;
        if (repository.equals(currentRepository)) {
            this.getTemplatePresentation().setIcon(PlatformIcons.CHECK_ICON);
        }
        this.getTemplatePresentation().setText(DvcsUtil.getShortRepositoryName(repository), false);
    }

    @NotNull
    public String getCaption() {
        String string2 = "Current branch in " + DvcsUtil.getShortRepositoryName(this.myRepository) + ": " + this.getInfoText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/RootAction", "getCaption"));
        }
        return string2;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        AnAction[] anActionArray = this.myGroup.getChildren(e2);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/RootAction", "getChildren"));
        }
        return anActionArray;
    }

    @Override
    @NotNull
    public String getInfoText() {
        String string2 = this.myBranchText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/RootAction", "getInfoText"));
        }
        return string2;
    }
}

