/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogSingleCommitAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "actionPerformed"));
        }
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e2.getRequiredData(VcsLogDataKeys.VCS_LOG);
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)log.getSelectedCommits());
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project2, commit.getRoot());
        assert (repository != null);
        this.actionPerformed(repository, commit.getHash());
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "update"));
        }
        Project project2 = e2.getProject();
        VcsLog log = (VcsLog)e2.getData(VcsLogDataKeys.VCS_LOG);
        if (project2 == null || log == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log.getSelectedCommits();
        if (commits.isEmpty()) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)commits);
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project2, commit.getRoot());
        if (repository == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setVisible(this.isVisible(project2, repository, commit.getHash()));
        e2.getPresentation().setEnabled(commits.size() == 1 && this.isEnabled(repository, commit.getHash()));
    }

    protected abstract void actionPerformed(@NotNull Repo var1, @NotNull Hash var2);

    protected boolean isEnabled(@NotNull Repo repository, @NotNull Hash commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "isEnabled"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "isEnabled"));
        }
        return true;
    }

    protected boolean isVisible(@NotNull Project project2, @NotNull Repo repository, @NotNull Hash hash) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "isVisible"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "isVisible"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/dvcs/ui/VcsLogSingleCommitAction", "isVisible"));
        }
        return !this.getRepositoryManager(project2).isExternal(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);
}

