/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.itn;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Map;
import java.util.function.IntConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ITNProxy {
    private static final String NEW_THREAD_VIEW_URL = "https://ea.jetbrains.com/browser/ea_reports/";
    private static final String NEW_THREAD_POST_URL = "https://ea-report.jetbrains.com/trackerRpc/idea/createScr";
    private static final String ENCODING = "UTF8";
    private static SSLContext ourSslContext;
    private static final String JB_CA_CERT = "-----BEGIN CERTIFICATE-----\nMIIFvjCCA6agAwIBAgIQMYHnK1dpIZVCoitWqBwhXjANBgkqhkiG9w0BAQsFADBn\nMRMwEQYKCZImiZPyLGQBGRYDTmV0MRgwFgYKCZImiZPyLGQBGRYISW50ZWxsaUox\nFDASBgoJkiaJk/IsZAEZFgRMYWJzMSAwHgYDVQQDExdKZXRCcmFpbnMgRW50ZXJw\ncmlzZSBDQTAeFw0xMjEyMjkxMDEyMzJaFw0zMjEyMjkxMDIyMzBaMGcxEzARBgoJ\nkiaJk/IsZAEZFgNOZXQxGDAWBgoJkiaJk/IsZAEZFghJbnRlbGxpSjEUMBIGCgmS\nJomT8ixkARkWBExhYnMxIDAeBgNVBAMTF0pldEJyYWlucyBFbnRlcnByaXNlIENB\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAzPCE2gPgKECo5CB3BTAw\n4XrrNpg+YwTMzeNNDYs4VdPzBq0snWsbm5qP6z1GBGUTr4agERQUxc4//gZMR0UJ\n89GWVNYPbZ/MrkfyaOiem8xosuZ+7WoFu4nYnKbBBMBA7S2idrPSmPv2wYiHJCY7\neN2AdViiFSAUeGw/7pIgou92/4Bbm6SSzRBKBYfRIfwq0ZgETSIjhNR5o3XJB5i2\nCkSjMk7kNiMWBaq+Alv+Um/xMFnl5jiq9H7YAALgH/mZHr8ANniSyBwkj4r/7GQ3\nUIYwoLrGxSOSEY9UhEpdqQkRbSSjQiFYMlhYEAtLERK4KZObTuUgdiE6Wk38EOKZ\nwy1eE/EIh8vWBHFSH5opPSK4dyamxj9o5c2g1hJ07ZBUCV/nsrKb+ruMkwBfI286\n+HPTMUmoKuUfSfHZ5TiuF5EvcSD7Df2ZCFpRugPs26FRGvtsiBMEmu4u6fu5RNkh\ns7Ueq6ISblt6dj/youywiAZnyrtNKJVyK0m051g9b2IokHjrk9XTswTqBHDjZKYr\nYG/5jDSSzvR/ptR9YIrHF0a9A6LQLZ6ews4FUO6O/RhiYXV8FggD7ZUg019OBUx3\nrF1L3GBYA8YhYP/N18r8DqOaFgUiRDyeRMbka9OXZ2KJT6iL+mOfg/svSW8lc4Ly\nEgcyJ9sk7MRwrhlp3Kc0W7UCAwEAAaNmMGQwEwYJKwYBBAGCNxQCBAYeBABDAEEw\nCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFB/HK/yYoWW9\nvr2XAyhcMmV3gSfGMBAGCSsGAQQBgjcVAQQDAgEAMA0GCSqGSIb3DQEBCwUAA4IC\nAQBnYu49dZRBK9W3voy6bgzz64sZfX51/RIA6aaoHAH3U1bC8EepChqWeRgijGCD\nCBvLTk7bk/7fgXPPvL+8RwYaxEewCi7t1RQKqPmNvUnEnw28OLvYLBEO7a4yeN5Y\nYaZwdfVH+0qMvTqMQku5p5Xx3dY+DAm4EqXEFD0svfeMJmOA+R1CIqRz1CXnN2FY\nA+86m7WLmGZ8oWlRUJDa1etqrE3ZxXHH/IunVJOGOfaQVkid3u3ageyUOnMw/iME\n7vi0UNVYVsCjXYZxrzCDLCxtguZaV4rMYvLRt1oUxZ+VnmdVa3aW0W//GQ70sqh2\nKQDtIF6Iumf8ya4vA0+K+AAowOSR/k4jQzlWQdZvJNMHP/Jc0OyJyHEegjtWssrS\nNoRtI6V4j277ugWF1Xpt1x0YxYyGSZTI4rqGLqVT8x6Llr24YaHCdp56rKWC/5ob\nIFZ7tJys7oQqof11ANDExrnHv/FEE39VDlfEIUVGyCpsyKbzO7MPfdOce2bIaQOS\ndQ76TpYClrnezikJgp9MSQmd3+ozs9w1upGynHNGNmVhzZ5sex9voWcGoyjmOFhs\nwg13S9Hjy3VYq8y0krRYLEGLctd4vnxWGzJzUNSnqezwHZRl4v4Ejp3dQUZP+5sY\n1F81Vj1G264YnZAcWp5x3GTI4K6+k9Xx3pwUPcKOYdlpZQ==\n-----END CERTIFICATE-----\n";
    private static final String JB_CA_CN = "JetBrains Enterprise CA";
    private static final String JB_CA_FP = "604d3c703a13a3be2d452f14442be11b37e186f";

    public static void sendError(@Nullable Project project2, final String login, final String password, final @NotNull ErrorBean error, final @NotNull IntConsumer callback, final @NotNull Consumer<Exception> errorCallback2) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/errorreport/itn/ITNProxy", "sendError"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/errorreport/itn/ITNProxy", "sendError"));
        }
        if (errorCallback2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCallback", "com/intellij/errorreport/itn/ITNProxy", "sendError"));
        }
        if (StringUtil.isEmpty((String)login)) {
            return;
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project2, DiagnosticBundle.message("title.submitting.error.report", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/errorreport/itn/ITNProxy$1", "run"));
                }
                try {
                    callback.accept(ITNProxy.postNewThread(login, password, error));
                }
                catch (Exception ex) {
                    errorCallback2.consume((Object)ex);
                }
            }
        };
        if (project2 == null) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)task2);
        }
    }

    @NotNull
    public static String getBrowseUrl(int threadId) {
        String string2 = NEW_THREAD_VIEW_URL + threadId;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/errorreport/itn/ITNProxy", "getBrowseUrl"));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int postNewThread(String login, String password, @NotNull ErrorBean error) throws Exception {
        String response;
        Multimap<String, String> params;
        HttpURLConnection connection;
        int responseCode;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/errorreport/itn/ITNProxy", "postNewThread"));
        }
        if (ourSslContext == null) {
            ourSslContext = ITNProxy.initContext();
        }
        if ((responseCode = (connection = ITNProxy.post(new URL(NEW_THREAD_POST_URL), ITNProxy.join(params = ITNProxy.createParameters(login, password, error)))).getResponseCode()) != 200) {
            throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", responseCode));
        }
        try (InputStream is = connection.getInputStream();){
            response = FileUtil.loadTextAndClose((InputStream)is);
        }
        if ("unauthorized".equals(response)) {
            throw new NoSuchEAPUserException(login);
        }
        if (response.startsWith("update ")) {
            throw new UpdateAvailableException(response.substring(7));
        }
        if (response.startsWith("message ")) {
            throw new InternalEAPException(response.substring(8));
        }
        try {
            return Integer.valueOf(response.trim());
        }
        catch (NumberFormatException ex) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
    }

    @NotNull
    private static Multimap<String, String> createParameters(String login, String password, @NotNull ErrorBean error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/errorreport/itn/ITNProxy", "createParameters"));
        }
        ArrayListMultimap params = ArrayListMultimap.create((int)40, (int)1);
        params.put((Object)"protocol.version", (Object)"1");
        params.put((Object)"user.login", (Object)login);
        params.put((Object)"user.password", (Object)password);
        params.put((Object)"os.name", (Object)SystemProperties.getOsName());
        params.put((Object)"java.version", (Object)SystemProperties.getJavaVersion());
        params.put((Object)"java.vm.vendor", (Object)SystemProperties.getJavaVmVendor());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        Application application = ApplicationManager.getApplication();
        params.put((Object)"app.name", (Object)namesInfo.getProductName());
        params.put((Object)"app.name.full", (Object)namesInfo.getFullProductName());
        params.put((Object)"app.name.version", (Object)appInfo.getVersionName());
        params.put((Object)"app.eap", (Object)Boolean.toString(appInfo.isEAP()));
        params.put((Object)"app.internal", (Object)Boolean.toString(application.isInternal()));
        params.put((Object)"app.build", (Object)appInfo.getApiVersion());
        params.put((Object)"app.version.major", (Object)appInfo.getMajorVersion());
        params.put((Object)"app.version.minor", (Object)appInfo.getMinorVersion());
        params.put((Object)"app.build.date", (Object)ITNProxy.format(appInfo.getBuildDate()));
        params.put((Object)"app.build.date.release", (Object)ITNProxy.format(appInfo.getMajorReleaseBuildDate()));
        params.put((Object)"app.compilation.timestamp", (Object)IdeaLogger.getOurCompilationTimestamp());
        BuildNumber build2 = appInfo.getBuild();
        String buildNumberWithAllDetails = build2.asString();
        params.put((Object)"app.product.code", (Object)build2.getProductCode());
        if (StringUtil.startsWith((CharSequence)buildNumberWithAllDetails, (CharSequence)(build2.getProductCode() + "-"))) {
            buildNumberWithAllDetails = buildNumberWithAllDetails.substring(build2.getProductCode().length() + 1);
        }
        params.put((Object)"app.build.number", (Object)buildNumberWithAllDetails);
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        params.put((Object)"update.channel.status", (Object)updateSettings.getSelectedChannelStatus().getCode());
        params.put((Object)"update.ignored.builds", (Object)StringUtil.join(updateSettings.getIgnoredBuildNumbers(), (String)","));
        params.put((Object)"plugin.name", (Object)error.getPluginName());
        params.put((Object)"plugin.version", (Object)error.getPluginVersion());
        params.put((Object)"last.action", (Object)error.getLastAction());
        params.put((Object)"previous.exception", error.getPreviousException() == null ? null : Integer.toString(error.getPreviousException()));
        params.put((Object)"error.message", (Object)error.getMessage());
        params.put((Object)"error.stacktrace", (Object)error.getStackTrace());
        params.put((Object)"error.description", (Object)error.getDescription());
        params.put((Object)"assignee.id", error.getAssigneeId() == null ? null : Integer.toString(error.getAssigneeId()));
        for (Attachment attachment : error.getAttachments()) {
            params.put((Object)"attachment.name", (Object)attachment.getName());
            params.put((Object)"attachment.value", (Object)attachment.getEncodedBytes());
        }
        ArrayListMultimap arrayListMultimap = params;
        if (arrayListMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/errorreport/itn/ITNProxy", "createParameters"));
        }
        return arrayListMultimap;
    }

    @Nullable
    private static String format(@Nullable Calendar calendar) {
        return calendar == null ? null : Long.toString(calendar.getTime().getTime());
    }

    private static byte[] join(@NotNull Multimap<String, String> params) throws UnsupportedEncodingException {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/errorreport/itn/ITNProxy", "join"));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry param : params.entries()) {
            if (StringUtil.isEmpty((String)((String)param.getKey()))) {
                throw new IllegalArgumentException(param.toString());
            }
            if (builder.length() > 0) {
                builder.append('&');
            }
            if (!StringUtil.isNotEmpty((String)((String)param.getValue()))) continue;
            builder.append((String)param.getKey()).append('=').append(URLEncoder.encode((String)param.getValue(), ENCODING));
        }
        return builder.toString().getBytes(ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static HttpURLConnection post(@NotNull URL url, @NotNull byte[] bytes) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/errorreport/itn/ITNProxy", "post"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/errorreport/itn/ITNProxy", "post"));
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(ourSslContext.getSocketFactory());
        if (!NetUtils.isSniEnabled()) {
            connection.setHostnameVerifier(new EaHostnameVerifier());
        }
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF8");
        connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        try (OutputStream out = connection.getOutputStream();){
            out.write(bytes);
        }
        HttpsURLConnection httpsURLConnection = connection;
        if (httpsURLConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/errorreport/itn/ITNProxy", "post"));
        }
        return httpsURLConnection;
    }

    private static synchronized SSLContext initContext() throws GeneralSecurityException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate ca = cf.generateCertificate(new ByteArrayInputStream(JB_CA_CERT.getBytes(ENCODING)));
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setCertificateEntry("JetBrains CA", ca);
        TrustManagerFactory jbTmf = TrustManagerFactory.getInstance("X.509");
        jbTmf.init(ks);
        TrustManagerFactory sysTmf = TrustManagerFactory.getInstance("X.509");
        sysTmf.init((KeyStore)null);
        SSLContext ctx = SSLContext.getInstance("TLS");
        CompositeX509TrustManager composite = new CompositeX509TrustManager((TrustManager[][])new TrustManager[][]{jbTmf.getTrustManagers(), sysTmf.getTrustManagers()});
        ctx.init(null, new TrustManager[]{composite}, null);
        return ctx;
    }

    private static class EaHostnameVerifier
    implements HostnameVerifier {
        private EaHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, @NotNull SSLSession session2) {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/errorreport/itn/ITNProxy$EaHostnameVerifier", "verify"));
            }
            try {
                Certificate[] certificates = session2.getPeerCertificates();
                if (certificates.length > 1) {
                    String cn;
                    Certificate certificate = certificates[0];
                    if (certificate instanceof X509Certificate && ((cn = CertificateUtil.getCommonName((X509Certificate)((X509Certificate)certificate))).endsWith(".jetbrains.com") || cn.endsWith(".intellij.net"))) {
                        return true;
                    }
                    Certificate ca = certificates[certificates.length - 1];
                    if (ca instanceof X509Certificate) {
                        String cn2 = CertificateUtil.getCommonName((X509Certificate)((X509Certificate)ca));
                        byte[] digest = MessageDigest.getInstance("SHA-1").digest(ca.getEncoded());
                        StringBuilder fp = new StringBuilder(2 * digest.length);
                        for (byte b2 : digest) {
                            fp.append(Integer.toHexString(b2 & 0xFF));
                        }
                        if (ITNProxy.JB_CA_CN.equals(cn2) && ITNProxy.JB_CA_FP.equals(fp.toString())) {
                            return true;
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException | SSLPeerUnverifiedException exception) {
                // empty catch block
            }
            return false;
        }
    }
}

