/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(@NotNull String executorId, RunnerAndConfigurationSettings configuration) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ProgramRunnerUtil", "getRunner"));
        }
        return configuration == null ? null : RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        ProgramRunnerUtil.executeConfigurationAsync(environment, showSettings, assignNewId, null);
    }

    public static void executeConfigurationAsync(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId, ProgramRunner.Callback callback) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ProgramRunnerUtil", "executeConfigurationAsync"));
        }
        if (ExecutorRegistry.getInstance().isStarting(environment)) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        Project project2 = environment.getProject();
        if (runnerAndConfigurationSettings != null) {
            ConfigurationType configurationType;
            if (!ExecutionTargetManager.canRun((ExecutionEnvironment)environment)) {
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(StringUtil.escapeXml((String)("Cannot run '" + environment.getRunProfile().getName() + "' on '" + environment.getExecutionTarget().getDisplayName() + "'"))));
                return;
            }
            if ((!RunManagerImpl.canRunConfiguration(environment) || showSettings && runnerAndConfigurationSettings.isEditBeforeRun()) && !DumbService.isDumb((Project)project2)) {
                if (!RunDialog.editConfiguration(environment, "Edit configuration")) {
                    return;
                }
                while (!RunManagerImpl.canRunConfiguration(environment) && 0 == Messages.showYesNoDialog((Project)project2, (String)"Configuration is still incorrect. Do you want to edit it again?", (String)"Change Configuration Settings", (String)"Edit", (String)"Continue Anyway", (Icon)Messages.getErrorIcon())) {
                    if (RunDialog.editConfiguration(environment, "Edit configuration")) continue;
                    return;
                }
            }
            if ((configurationType = runnerAndConfigurationSettings.getType()) != null) {
                UsageTrigger.trigger("execute." + ConvertUsagesUtil.ensureProperKey(configurationType.getId()) + "." + environment.getExecutor().getId());
            }
        }
        try {
            if (assignNewId) {
                environment.assignNewExecutionId();
            }
            if (DumbService.isDumb((Project)project2) && Registry.is((String)"dumb.aware.run.configurations")) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (environment == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ProgramRunnerUtil", "lambda$executeConfigurationAsync$0"));
                    }
                    if (project2.isDisposed()) {
                        return;
                    }
                    String toolWindowId = ExecutionManager.getInstance((Project)project2).getContentManager().getToolWindowIdByEnvironment(environment);
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                    if (toolWindowManager.canShowNotification(toolWindowId)) {
                        toolWindowManager.notifyByBalloon(toolWindowId, MessageType.INFO, "Some actions may not work as expected if you start a Run/debug configuration while indexing is in progress.");
                    }
                });
            }
            if (callback != null) {
                environment.getRunner().execute(environment, callback);
            } else {
                environment.getRunner().execute(environment);
            }
        }
        catch (ExecutionException e2) {
            String name;
            String string2 = name = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getName() : null;
            if (name == null) {
                name = environment.getRunProfile().getName();
            }
            if (name == null && environment.getContentToReuse() != null) {
                name = environment.getContentToReuse().getDisplayName();
            }
            if (name == null) {
                name = "<Unknown>";
            }
            ExecutionUtil.handleExecutionError((Project)project2, (String)ExecutionManager.getInstance((Project)project2).getContentManager().getToolWindowIdByEnvironment(environment), (String)name, (ExecutionException)e2);
        }
    }

    public static void executeConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor2) {
        ExecutionEnvironmentBuilder builder;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (executor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        try {
            builder = ExecutionEnvironmentBuilder.create((Executor)executor2, (RunnerAndConfigurationSettings)configuration);
        }
        catch (ExecutionException e2) {
            LOG.error((Throwable)e2);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    public static Icon getConfigurationIcon(RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon2 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    @NotNull
    public static Icon getRawIcon(RunnerAndConfigurationSettings settings) {
        Icon icon;
        RunConfiguration configuration = settings.getConfiguration();
        ConfigurationFactory factory2 = settings.getFactory();
        Icon icon2 = icon = factory2 != null ? factory2.getIcon(configuration) : null;
        if (icon == null) {
            icon = AllIcons.RunConfigurations.Unknown;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ProgramRunnerUtil", "getRawIcon"));
        }
        return icon3;
    }

    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        if (rawIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawIcon", "com/intellij/execution/ProgramRunnerUtil", "getTemporaryIcon"));
        }
        return IconLoader.getTransparentIcon((Icon)rawIcon, (float)0.3f);
    }

    public static String shortenName(@Nullable String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        return name.length() < symbols + 3 ? name : name.substring(0, symbols) + "...";
    }
}

