/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private static final int CURRENT_VERSION = 1;
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(Project project2) {
        return new File(TEST_HISTORY_PATH, project2.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/TestStateStorage", "getInstance"));
        }
        return (TestStateStorage)ServiceManager.getService((Project)project2, TestStateStorage.class);
    }

    public TestStateStorage(Project project2) {
        String directoryPath = TestStateStorage.getTestHistoryRoot(project2).getPath();
        this.myFile = new File(directoryPath + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
        }
        this.myMapFlusher = FlushingDaemon.everyFiveSeconds(this::flushMap);
    }

    private PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(File file2) {
        ThrowableComputable throwableComputable = () -> new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<Record>(){

            public void save(@NotNull DataOutput out, Record value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/TestStateStorage$1", "save"));
                }
                out.writeInt(value2.magnitude);
                out.writeLong(value2.date.getTime());
                out.writeLong(value2.configurationHash);
            }

            public Record read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/execution/TestStateStorage$1", "read"));
                }
                return new Record(in.readInt(), new Date(in.readLong()), in.readLong());
            }
        }, 4096, 1);
        if (throwableComputable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/TestStateStorage", "getComputable"));
        }
        return throwableComputable;
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e2) {
            this.thingsWentWrongLetsReinitialize(e2, "Can't get state for " + testUrl);
            return null;
        }
    }

    public synchronized void removeState(String url) {
        if (this.myMap != null) {
            try {
                this.myMap.remove((Object)url);
            }
            catch (IOException e2) {
                this.thingsWentWrongLetsReinitialize(e2, "Can't remove state for " + url);
            }
        }
    }

    @Nullable
    public synchronized Map<String, Record> getRecentTests(int limit, Date since) {
        if (this.myMap == null) {
            return null;
        }
        HashMap result2 = ContainerUtil.newHashMap();
        try {
            for (String key : this.myMap.getAllKeysWithExistingMapping()) {
                Record record = (Record)this.myMap.get((Object)key);
                if (record == null || record.date.compareTo(since) <= 0) continue;
                result2.put(key, record);
                if (result2.size() < limit) continue;
                break;
            }
        }
        catch (IOException e2) {
            this.thingsWentWrongLetsReinitialize(e2, "Can't get recent tests");
        }
        return result2;
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testUrl", "com/intellij/execution/TestStateStorage", "writeState"));
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e2) {
            this.thingsWentWrongLetsReinitialize(e2, "Can't write state for " + testUrl);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
        }
        finally {
            this.myMap = null;
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e2, String message2) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.error(message2, (Throwable)e2);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    public static class Record {
        public final int magnitude;
        public final long configurationHash;
        public final Date date;

        public Record(int magnitude, Date date, long configurationHash) {
            this.magnitude = magnitude;
            this.date = date;
            this.configurationHash = configurationHash;
        }
    }
}

