/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor2) {
        if (executor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/RunContextAction", "<init>"));
        }
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor2.getStartActionText()}), null, executor2.getIcon());
        this.myExecutor = executor2;
    }

    @Override
    protected void perform(ConfigurationContext context2) {
        RunnerAndConfigurationSettings configuration = context2.findExisting();
        RunManagerEx runManager = (RunManagerEx)context2.getRunManager();
        if (configuration == null) {
            configuration = context2.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        if (Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(configuration);
        }
        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)this.myExecutor);
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration) {
        return RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context2) {
        if (actionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/RunContextAction", "updatePresentation"));
        }
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b2 = this.isEnabledAndVisible(context2);
        presentation.setEnabled(((Boolean)b2.first).booleanValue());
        presentation.setVisible(((Boolean)b2.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context2) {
        ProgramRunner runner;
        RunnerAndConfigurationSettings configuration = context2.findExisting();
        if (configuration == null) {
            configuration = context2.getConfiguration();
        }
        ProgramRunner programRunner = runner = configuration == null ? null : this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        return Pair.create((Object)(!ExecutorRegistry.getInstance().isStarting(context2.getProject(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }
}

