/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ShowRunningListAction
extends AnAction {
    private static final Object KEY = new Object();

    public ShowRunningListAction() {
        super(ExecutionBundle.message((String)"show.running.list.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"show.running.list.action.description", (Object[])new Object[0]), LayeredIcon.create((Icon)AllIcons.RunConfigurations.Variables, (Icon)AllIcons.Nodes.RunnableMark));
    }

    public void actionPerformed(final AnActionEvent e2) {
        final Project project2 = e2.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        final Ref stateRef = new Ref();
        final Ref balloonRef = new Ref();
        final Timer timer2 = UIUtil.createNamedTimer((String)"runningLists", (int)250);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Balloon balloon = (Balloon)balloonRef.get();
                if (project2.isDisposed() || balloon != null && balloon.isDisposed()) {
                    timer2.stop();
                    return;
                }
                ArrayList<Project> projects = new ArrayList<Project>(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
                projects.remove(project2);
                projects.add(0, project2);
                Pair state = ShowRunningListAction.getCurrentState(projects);
                Pair prevState = (Pair)stateRef.get();
                if (prevState != null && ((String)prevState.getSecond()).equals(state.getSecond())) {
                    return;
                }
                stateRef.set((Object)state);
                BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)state.getFirst());
                builder.setShowCallout(false).setTitle(ExecutionBundle.message((String)"show.running.list.balloon.title", (Object[])new Object[0])).setBlockClicksThroughBalloon(true).setDialogMode(true).setHideOnKeyOutside(false);
                IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData(e2.getDataContext());
                if (frame == null) {
                    frame = WindowManagerEx.getInstanceEx().getFrame(project2);
                }
                if (balloon != null) {
                    balloon.hide();
                }
                builder.setClickHandler(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        if (e2.getSource() instanceof MouseEvent) {
                            MouseEvent mouseEvent = (MouseEvent)e2.getSource();
                            Component component = mouseEvent.getComponent();
                            Object value2 = ((JComponent)(component = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY()))).getClientProperty(KEY);
                            if (value2 instanceof Trinity) {
                                Project aProject = (Project)((Trinity)value2).first;
                                JFrame aFrame = WindowManager.getInstance().getFrame(aProject);
                                if (aFrame != null && !aFrame.isActive()) {
                                    aFrame.requestFocus();
                                }
                                ExecutionManagerImpl.getInstance(aProject).getContentManager().toFrontRunContent((Executor)((Trinity)value2).second, (RunContentDescriptor)((Trinity)value2).third);
                            }
                        }
                    }
                }, false);
                balloon = builder.createBalloon();
                balloonRef.set((Object)balloon);
                JComponent component = frame.getComponent();
                RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth(), 0));
                balloon.show(point, Balloon.Position.below);
            }
        };
        timer2.addActionListener(actionListener);
        timer2.setInitialDelay(0);
        timer2.start();
    }

    private static Pair<? extends JComponent, String> getCurrentState(@NotNull List<Project> projects) {
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "com/intellij/execution/actions/ShowRunningListAction", "getCurrentState"));
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        StringBuilder state = new StringBuilder();
        for (int i2 = 0; i2 < projects.size(); ++i2) {
            Project project2 = projects.get(i2);
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project2);
            List<RunContentDescriptor> runningDescriptors = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)Condition.TRUE);
            if (!runningDescriptors.isEmpty() && projects.size() > 1) {
                state.append(project2.getName());
                panel2.add((Component)new JLabel("<html><body><b>Project '" + project2.getName() + "'</b></body></html>"));
            }
            for (RunContentDescriptor descriptor2 : runningDescriptors) {
                Set<Executor> executors = executionManager.getExecutors(descriptor2);
                for (Executor executor2 : executors) {
                    state.append(System.identityHashCode(descriptor2.getAttachedContent())).append("@").append(System.identityHashCode(executor2.getIcon())).append(";");
                    ProcessHandler processHandler2 = descriptor2.getProcessHandler();
                    Icon icon = processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating() ? AllIcons.Debugger.KillProcess : executor2.getIcon();
                    JLabel label = new JLabel("<html><body><a href=\"\">" + descriptor2.getDisplayName() + "</a></body></html>", icon, 10);
                    label.setIconTextGap(JBUI.scale((int)2));
                    label.setCursor(Cursor.getPredefinedCursor(12));
                    label.putClientProperty(KEY, Trinity.create((Object)project2, (Object)executor2, (Object)descriptor2));
                    panel2.add((Component)label);
                }
            }
        }
        if (panel2.getComponentCount() == 0) {
            panel2.setBorder(JBUI.Borders.empty((int)10));
            panel2.add((Component)new JLabel(ExecutionBundle.message((String)"show.running.list.balloon.nothing", (Object[])new Object[0]), 0));
        } else {
            panel2.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10));
            JLabel label = new JLabel(ExecutionBundle.message((String)"show.running.list.balloon.hint", (Object[])new Object[0]));
            label.setFont((Font)JBUI.Fonts.miniFont());
            panel2.add((Component)label);
        }
        return Pair.create((Object)panel2, (Object)state.toString());
    }

    public void update(AnActionEvent e2) {
        Project[] projects;
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            boolean enabled = project2 != null && !project2.isDisposed() && !ExecutionManagerImpl.getInstance(project2).getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)Condition.TRUE).isEmpty();
            e2.getPresentation().setEnabled(enabled);
            if (enabled) break;
        }
    }
}

