/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private WeakReference<JBPopup> myActivePopupRef = null;

    StopAction() {
    }

    private static boolean isPlaceGlobal(AnActionEvent e2) {
        return ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace()) || "MainToolbar".equals(e2.getPlace()) || "NavBarToolbar".equals(e2.getPlace());
    }

    public void update(AnActionEvent e2) {
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e2.getPresentation();
        if (StopAction.isPlaceGlobal(e2)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e2.getDataContext());
            List<Pair<TaskInfo, ProgressIndicator>> cancellableProcesses = StopAction.getCancellableProcesses(e2.getProject());
            int todoSize = stoppableDescriptors.size() + cancellableProcesses.size();
            if (todoSize > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
            } else if (todoSize == 1) {
                if (stoppableDescriptors.size() == 1) {
                    presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)stoppableDescriptors.get(0).getDisplayName())}));
                } else {
                    TaskInfo taskInfo = (TaskInfo)cancellableProcesses.get((int)0).first;
                    presentation.setText(taskInfo.getCancelText() + " " + taskInfo.getTitle());
                }
            } else {
                presentation.setText(this.getTemplatePresentation().getText());
            }
            boolean bl = enable = todoSize > 0;
            if (todoSize > 1) {
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(todoSize));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler2;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e2.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler3 = processHandler2 = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
                if (!processHandler2.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
            if ((runProfile = (RunProfile)e2.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? contentDescriptor.getDisplayName() : runProfile.getName()))}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        Project project2 = e2.getProject();
        List<Pair<TaskInfo, ProgressIndicator>> cancellableProcesses = StopAction.getCancellableProcesses(project2);
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        if (StopAction.isPlaceGlobal(e2)) {
            Component component;
            int todoSize = cancellableProcesses.size() + stoppableDescriptors.size();
            if (todoSize == 1) {
                if (!stoppableDescriptors.isEmpty()) {
                    ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                } else {
                    ((ProgressIndicator)cancellableProcesses.get((int)0).second).cancel();
                }
                return;
            }
            final Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(cancellableProcesses, stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            JBList list2 = new JBList((Collection)handlerItems.first);
            if (handlerItems.second != null) {
                list2.setSelectedValue(handlerItems.second, true);
            }
            HandlerItem stopAllItem = new HandlerItem(ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), AllIcons.Actions.Suspend, true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        item.stop();
                    }
                }
            };
            ((DefaultListModel)list2.getModel()).addElement(stopAllItem);
            JBPopup activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef);
            if (activePopup != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            list2.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<HandlerItem>(){

                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            }));
            JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setMovable(true).setTitle(((List)handlerItems.first).size() == 1 ? "Confirm process stop" : "Stop process").setFilteringEnabled(o2 -> ((HandlerItem)o2).displayName).setItemChoosenCallback(() -> {
                List valuesList = list2.getSelectedValuesList();
                for (Object o2 : valuesList) {
                    if (!(o2 instanceof HandlerItem)) continue;
                    ((HandlerItem)o2).stop();
                }
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    StopAction.this.myActivePopupRef = null;
                }
            }).setRequestFocus(true).createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup2);
            InputEvent inputEvent = e2.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null && "MainToolbar".equals(e2.getPlace())) {
                popup2.showUnderneathOf(component);
            } else if (project2 == null) {
                popup2.showInBestPositionFor(dataContext);
            } else {
                popup2.showCenteredInCurrentWindow(project2);
            }
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @NotNull
    private static List<Pair<TaskInfo, ProgressIndicator>> getCancellableProcesses(@Nullable Project project2) {
        List<Pair<TaskInfo, ProgressIndicator>> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getCancellableProcesses"));
        }
        return list2;
    }

    @Nullable
    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<Pair<TaskInfo, ProgressIndicator>> tasks, List<RunContentDescriptor> descriptors, RunContentDescriptor toSelect) {
        if (tasks.isEmpty() && descriptors.isEmpty()) {
            return null;
        }
        ArrayList<HandlerItem> items2 = new ArrayList<HandlerItem>(tasks.size() + descriptors.size());
        HandlerItem selected = null;
        for (final RunContentDescriptor descriptor2 : descriptors) {
            ProcessHandler handler2 = descriptor2.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(descriptor2.getDisplayName(), descriptor2.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(descriptor2);
                }
            };
            items2.add(item);
            if (descriptor2 != toSelect) continue;
            selected = item;
        }
        boolean hasSeparator = true;
        for (final Pair<TaskInfo, ProgressIndicator> eachPair : tasks) {
            items2.add(new HandlerItem(((TaskInfo)eachPair.first).getTitle(), AllIcons.Process.Step_passive, hasSeparator){

                @Override
                void stop() {
                    ((ProgressIndicator)eachPair.second).cancel();
                }
            });
            hasSeparator = false;
        }
        return Pair.create(items2, selected);
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/actions/StopAction", "getRecentlyStartedContentDescriptor"));
        }
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext);
        if (contentDescriptor != null) {
            return contentDescriptor;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project2 == null ? null : ExecutionManager.getInstance((Project)project2).getContentManager().getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            List<RunContentDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list2;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project2).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list3;
        }
        ArrayList<RunContentDescriptor> activeDescriptors = new ArrayList<RunContentDescriptor>();
        for (RunContentDescriptor descriptor2 : runningProcesses) {
            if (!StopAction.canBeStopped(descriptor2)) continue;
            activeDescriptors.add(descriptor2);
        }
        ArrayList<RunContentDescriptor> arrayList = activeDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
        }
        return arrayList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor2) {
        ProcessHandler processHandler2 = descriptor2 != null ? descriptor2.getProcessHandler() : null;
        return processHandler2 != null && !processHandler2.isProcessTerminated() && (!processHandler2.isProcessTerminating() || processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess());
    }

    private static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        private HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

