/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.compound.CompoundRunConfigurationSettingsEditor;
import com.intellij.execution.compound.CompoundRunConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundRunConfiguration
extends RunConfigurationBase
implements RunnerIconProvider,
WithoutOwnBeforeRunSteps,
Cloneable {
    static final Comparator<RunConfiguration> COMPARATOR = (o1, o2) -> {
        int i2 = o1.getType().getDisplayName().compareTo(o2.getType().getDisplayName());
        return i2 != 0 ? i2 : o1.getName().compareTo(o2.getName());
    };
    private Set<Pair<String, String>> myPairs;
    private Set<RunConfiguration> mySetToRun;
    private boolean myInitialized;

    public CompoundRunConfiguration(Project project2, @NotNull CompoundRunConfigurationType type, String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/compound/CompoundRunConfiguration", "<init>"));
        }
        super(project2, type.getConfigurationFactories()[0], name);
        this.myPairs = new HashSet<Pair<String, String>>();
        this.mySetToRun = new TreeSet<RunConfiguration>(COMPARATOR);
        this.myInitialized = false;
    }

    public Set<RunConfiguration> getSetToRun() {
        this.initIfNeed();
        return this.mySetToRun;
    }

    private void initIfNeed() {
        if (this.myInitialized) {
            return;
        }
        this.mySetToRun.clear();
        RunManagerImpl manager = RunManagerImpl.getInstanceImpl(this.getProject());
        for (Pair<String, String> pair : this.myPairs) {
            RunnerAndConfigurationSettings settings = manager.findConfigurationByTypeAndName((String)pair.first, (String)pair.second);
            if (settings == null || settings.getConfiguration() == this) continue;
            this.mySetToRun.add(settings.getConfiguration());
        }
        this.myInitialized = true;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CompoundRunConfigurationSettingsEditor compoundRunConfigurationSettingsEditor = new CompoundRunConfigurationSettingsEditor(this.getProject());
        if (compoundRunConfigurationSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/compound/CompoundRunConfiguration", "getConfigurationEditor"));
        }
        return compoundRunConfigurationSettingsEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getSetToRun().isEmpty()) {
            throw new RuntimeConfigurationException("There is nothing to run");
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/compound/CompoundRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/compound/CompoundRunConfiguration", "getState"));
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationException e2) {
            throw new ExecutionException(e2.getMessage());
        }
        return new RunProfileState(){

            @Nullable
            public ExecutionResult execute(Executor executor2, @NotNull ProgramRunner runner) throws ExecutionException {
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/compound/CompoundRunConfiguration$1", "execute"));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    RunManagerImpl manager = RunManagerImpl.getInstanceImpl(CompoundRunConfiguration.this.getProject());
                    for (RunConfiguration configuration : CompoundRunConfiguration.this.getSetToRun()) {
                        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(manager, configuration, false);
                        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor2, (RunnerAndConfigurationSettings)settings);
                        if (builder == null) continue;
                        ExecutionManager.getInstance((Project)CompoundRunConfiguration.this.getProject()).restartRunProfile(builder.activeTarget().dataContext(null).build());
                    }
                });
                return null;
            }
        };
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myPairs.clear();
        List children2 = element.getChildren("toRun");
        for (Element child : children2) {
            String type = child.getAttributeValue("type");
            String name = child.getAttributeValue("name");
            if (type == null || name == null) continue;
            this.myPairs.add((Pair<String, String>)Pair.create((Object)type, (Object)name));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        for (RunConfiguration configuration : this.getSetToRun()) {
            Element child = new Element("toRun");
            child.setAttribute("type", configuration.getType().getId());
            child.setAttribute("name", configuration.getName());
            element.addContent(child);
        }
    }

    public RunConfiguration clone() {
        CompoundRunConfiguration clone = (CompoundRunConfiguration)super.clone();
        clone.myPairs = new HashSet<Pair<String, String>>();
        clone.myPairs.addAll(this.myPairs);
        clone.mySetToRun = new TreeSet<RunConfiguration>(COMPARATOR);
        clone.mySetToRun.addAll(this.getSetToRun());
        return clone;
    }

    @Nullable
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor2) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/compound/CompoundRunConfiguration", "getExecutorIcon"));
        }
        if (executor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/compound/CompoundRunConfiguration", "getExecutorIcon"));
        }
        if (DefaultRunExecutor.EXECUTOR_ID.equals(executor2.getId()) && this.hasRunningSingletones()) {
            return AllIcons.Actions.Restart;
        }
        return executor2.getIcon();
    }

    protected boolean hasRunningSingletones() {
        Project project2 = this.getProject();
        if (project2.isDisposed()) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project2);
        return executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)s2 -> {
            RunManagerImpl manager = RunManagerImpl.getInstanceImpl(project2);
            for (RunConfiguration runConfiguration : this.mySetToRun) {
                if (runConfiguration instanceof CompoundRunConfiguration && ((CompoundRunConfiguration)runConfiguration).hasRunningSingletones()) {
                    return true;
                }
                RunnerAndConfigurationSettings settings = manager.findConfigurationByTypeAndName(runConfiguration.getType().getId(), runConfiguration.getName());
                if (settings == null || !settings.isSingleton() || !runConfiguration.equals(s2.getConfiguration())) continue;
                return true;
            }
            return false;
        })).size() > 0;
    }
}

