/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.AppTopics;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.HistoryRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.xml.util.XmlStringUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.TObjectHashingStrategy;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ConsoleHistoryController {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.console.ConsoleHistoryController");
    private static final FactoryMap<String, ConsoleHistoryModel> ourModels = new FactoryMap<String, ConsoleHistoryModel>(){

        protected Map<String, ConsoleHistoryModel> createMap() {
            return ContainerUtil.createConcurrentWeakValueMap();
        }

        protected ConsoleHistoryModel create(String key) {
            return new ConsoleHistoryModel(null);
        }
    };
    private static final Map<LanguageConsoleView, ConsoleHistoryController> ourControllers = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private final LanguageConsoleView myConsole;
    private final AnAction myHistoryNext;
    private final AnAction myHistoryPrev;
    private final AnAction myBrowseHistory;
    private boolean myMultiline;
    private final ModelHelper myHelper;
    private long myLastSaveStamp;

    @Deprecated
    public ConsoleHistoryController(@NotNull String type, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        this(new ConsoleRootType(type, null){}, persistenceId, console);
    }

    public ConsoleHistoryController(@NotNull ConsoleRootType rootType, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        this(rootType, persistenceId, console, (ConsoleHistoryModel)((Object)ourModels.get((Object)ConsoleHistoryController.getHistoryName(rootType, ConsoleHistoryController.fixNullPersistenceId(persistenceId, console)))));
    }

    private ConsoleHistoryController(@NotNull ConsoleRootType rootType, @Nullable String persistenceId, @NotNull LanguageConsoleView console, @NotNull ConsoleHistoryModel model2) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        this.myHistoryNext = new MyAction(true, ConsoleHistoryController.getKeystrokesUpDown(true));
        this.myHistoryPrev = new MyAction(false, ConsoleHistoryController.getKeystrokesUpDown(false));
        this.myBrowseHistory = new MyBrowseAction();
        this.myHelper = new ModelHelper(rootType, ConsoleHistoryController.fixNullPersistenceId(persistenceId, console), model2.copy());
        this.myConsole = console;
    }

    public static ConsoleHistoryController getController(@NotNull LanguageConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "getController"));
        }
        return ourControllers.get(console);
    }

    public static void addToHistory(@NotNull LanguageConsoleView consoleView, @Nullable String command) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/console/ConsoleHistoryController", "addToHistory"));
        }
        ConsoleHistoryController controller = ConsoleHistoryController.getController(consoleView);
        if (controller != null) {
            controller.addToHistory(command);
        }
    }

    public void addToHistory(@Nullable String command) {
        this.getModel().addToHistory(command);
    }

    public boolean hasHistory() {
        return !this.getModel().isEmpty();
    }

    @NotNull
    private static String fixNullPersistenceId(@Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "fixNullPersistenceId"));
        }
        if (StringUtil.isNotEmpty((String)persistenceId)) {
            String string2 = persistenceId;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController", "fixNullPersistenceId"));
            }
            return string2;
        }
        String url = console.getProject().getPresentableUrl();
        String string3 = StringUtil.isNotEmpty((String)url) ? url : "default";
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController", "fixNullPersistenceId"));
        }
        return string3;
    }

    public boolean isMultiline() {
        return this.myMultiline;
    }

    public ConsoleHistoryController setMultiline(boolean multiline) {
        this.myMultiline = multiline;
        return this;
    }

    ConsoleHistoryModel getModel() {
        return this.myHelper.getModel();
    }

    public void install() {
        class Listener
        extends FileDocumentManagerAdapter
        implements ProjectEx.ProjectSaved {
            Listener() {
            }

            public void beforeDocumentSaving(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/ConsoleHistoryController$1Listener", "beforeDocumentSaving"));
                }
                if (document == ConsoleHistoryController.this.myConsole.getEditorDocument()) {
                    ConsoleHistoryController.this.saveHistory();
                }
            }

            @Override
            public void saved(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/ConsoleHistoryController$1Listener", "saved"));
                }
                ConsoleHistoryController.this.saveHistory();
            }
        }
        Listener listener2 = new Listener();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myConsole).subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)listener2);
        this.myConsole.getProject().getMessageBus().connect((Disposable)this.myConsole).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)listener2);
        ConsoleHistoryController original = ourControllers.put(this.myConsole, this);
        LOG.assertTrue(original == null, (Object)("History controller already installed for: " + this.myConsole.getTitle()));
        Disposer.register((Disposable)this.myConsole, (Disposable)new Disposable(){

            public void dispose() {
                ConsoleHistoryController controller = ConsoleHistoryController.getController(ConsoleHistoryController.this.myConsole);
                if (controller == ConsoleHistoryController.this) {
                    ourControllers.remove(ConsoleHistoryController.this.myConsole);
                }
                ConsoleHistoryController.this.saveHistory();
            }
        });
        if (this.myHelper.getModel().getHistorySize() == 0) {
            this.loadHistory(this.myHelper.getId());
        }
        this.configureActions();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    private long getCurrentTimeStamp() {
        return this.getModel().getModificationCount() + this.myConsole.getEditorDocument().getModificationStamp();
    }

    private void configureActions() {
        EmptyAction.setupAction((AnAction)this.myHistoryNext, (String)"Console.History.Next", null);
        EmptyAction.setupAction((AnAction)this.myHistoryPrev, (String)"Console.History.Previous", null);
        EmptyAction.setupAction((AnAction)this.myBrowseHistory, (String)"Console.History.Browse", null);
        if (!this.myMultiline) {
            ConsoleHistoryController.addShortcuts(this.myHistoryNext, ConsoleHistoryController.getShortcutUpDown(true));
            ConsoleHistoryController.addShortcuts(this.myHistoryPrev, ConsoleHistoryController.getShortcutUpDown(false));
        }
        this.myHistoryNext.registerCustomShortcutSet(this.myHistoryNext.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myHistoryPrev.registerCustomShortcutSet(this.myHistoryPrev.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myBrowseHistory.registerCustomShortcutSet(this.myBrowseHistory.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
    }

    public boolean loadHistory(String id) {
        String prev = this.myHelper.getContent();
        boolean result2 = this.myHelper.loadHistory(id, this.myConsole.getVirtualFile());
        String userValue = this.myHelper.getContent();
        if (prev != userValue && userValue != null) {
            this.setConsoleText(userValue, false, false);
        }
        return result2;
    }

    private void saveHistory() {
        if (this.myLastSaveStamp == this.getCurrentTimeStamp()) {
            return;
        }
        this.myHelper.setContent(this.myConsole.getEditorDocument().getText());
        this.myHelper.saveHistory();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    public AnAction getHistoryNext() {
        return this.myHistoryNext;
    }

    public AnAction getHistoryPrev() {
        return this.myHistoryPrev;
    }

    public AnAction getBrowseHistory() {
        return this.myBrowseHistory;
    }

    protected void setConsoleText(final String command, final boolean storeUserText, final boolean regularMode) {
        if (regularMode && this.myMultiline && StringUtil.isEmptyOrSpaces((String)command)) {
            return;
        }
        final EditorEx editor = this.myConsole.getCurrentEditor();
        final Document document = editor.getDocument();
        new WriteCommandAction.Simple(this.myConsole.getProject(), new PsiFile[0]){

            public void run() {
                int offset;
                String text2;
                if (storeUserText) {
                    text2 = document.getText();
                    if (Comparing.equal((String)command, (String)text2) && ConsoleHistoryController.this.myHelper.getContent() != null) {
                        return;
                    }
                    ConsoleHistoryController.this.myHelper.setContent(text2);
                }
                text2 = StringUtil.notNullize((String)command);
                if (regularMode) {
                    if (ConsoleHistoryController.this.myMultiline) {
                        offset = ConsoleHistoryController.this.insertTextMultiline(text2, editor, document);
                    } else {
                        document.setText((CharSequence)text2);
                        offset = document.getTextLength();
                    }
                } else {
                    offset = 0;
                    try {
                        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
                        document.setText((CharSequence)text2);
                    }
                    finally {
                        document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
                    }
                }
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }.execute();
    }

    protected int insertTextMultiline(String text2, Editor editor, Document document) {
        TextRange selection = EditorUtil.getSelectionInAnyMode(editor);
        int start2 = document.getLineStartOffset(document.getLineNumber(selection.getStartOffset()));
        int end = document.getLineEndOffset(document.getLineNumber(selection.getEndOffset()));
        document.replaceString(start2, end, (CharSequence)text2);
        editor.getSelectionModel().setSelection(start2, start2 + text2.length());
        return start2;
    }

    private boolean canMoveInEditor(boolean next) {
        EditorEx consoleEditor = this.myConsole.getCurrentEditor();
        Document document = consoleEditor.getDocument();
        CaretModel caretModel = consoleEditor.getCaretModel();
        if (LookupManager.getActiveLookup(consoleEditor) != null) {
            return false;
        }
        if (next) {
            return document.getLineNumber(caretModel.getOffset()) == 0;
        }
        int lineCount = document.getLineCount();
        return (lineCount == 0 || document.getLineNumber(caretModel.getOffset()) == lineCount - 1) && StringUtil.isEmptyOrSpaces((String)document.getText().substring(caretModel.getOffset()));
    }

    private static void textTag(@NotNull XmlSerializer out, @NotNull String tag, @NotNull String text2) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        out.startTag(null, tag);
        try {
            out.ignorableWhitespace(XmlStringUtil.wrapInCDATA((String)text2));
        }
        finally {
            out.endTag(null, tag);
        }
    }

    @NotNull
    private static String getHistoryName(@NotNull ConsoleRootType rootType, @NotNull String id) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/execution/console/ConsoleHistoryController", "getHistoryName"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/console/ConsoleHistoryController", "getHistoryName"));
        }
        String string2 = rootType.getConsoleTypeId() + "/" + PathUtil.makeFileName((String)rootType.getHistoryPathName(id), (String)rootType.getDefaultFileExtension());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController", "getHistoryName"));
        }
        return string2;
    }

    @Nullable
    public static VirtualFile getContentFile(@NotNull ConsoleRootType rootType, @NotNull String id, ScratchFileService.Option option) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/execution/console/ConsoleHistoryController", "getContentFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/console/ConsoleHistoryController", "getContentFile"));
        }
        String pathName = PathUtil.makeFileName((String)rootType.getContentPathName(id), (String)rootType.getDefaultFileExtension());
        try {
            return rootType.findFile(null, pathName, option);
        }
        catch (IOException e2) {
            LOG.warn((Throwable)e2);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (rootType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/execution/console/ConsoleHistoryController", "lambda$getContentFile$0"));
                }
                String message2 = String.format("Unable to open '%s/%s'\nReason: %s", rootType.getId(), pathName, e2.getLocalizedMessage());
                Messages.showErrorDialog((String)message2, (String)"Unable to Open File");
            });
            return null;
        }
    }

    private static ShortcutSet getShortcutUpDown(boolean isUp) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(isUp ? "EditorUp" : "EditorDown");
        if (action2 != null) {
            return action2.getShortcutSet();
        }
        return new CustomShortcutSet(KeyStroke.getKeyStroke(isUp ? 38 : 40, 0));
    }

    private static void addShortcuts(@NotNull AnAction action2, @NotNull ShortcutSet newShortcuts) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/console/ConsoleHistoryController", "addShortcuts"));
        }
        if (newShortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newShortcuts", "com/intellij/execution/console/ConsoleHistoryController", "addShortcuts"));
        }
        if (action2.getShortcutSet().getShortcuts().length == 0) {
            action2.registerCustomShortcutSet(newShortcuts, null);
        } else {
            action2.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{action2.getShortcutSet(), newShortcuts}), null);
        }
    }

    private static Collection<KeyStroke> getKeystrokesUpDown(boolean isUp) {
        ArrayList<KeyStroke> result2 = new ArrayList<KeyStroke>();
        ShortcutSet shortcutSet = ConsoleHistoryController.getShortcutUpDown(isUp);
        for (Shortcut shortcut : shortcutSet.getShortcuts()) {
            if (!shortcut.isKeyboard() || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result2.add(((KeyboardShortcut)shortcut).getFirstKeyStroke());
        }
        return result2;
    }

    public static class ModelHelper {
        private final ConsoleRootType myRootType;
        private final String myId;
        private final ConsoleHistoryModel myModel;
        private String myContent;

        public ModelHelper(ConsoleRootType rootType, String id, ConsoleHistoryModel model2) {
            this.myRootType = rootType;
            this.myId = id;
            this.myModel = model2;
        }

        public ConsoleHistoryModel getModel() {
            return this.myModel;
        }

        public void setContent(String userValue) {
            this.myContent = userValue;
        }

        public String getId() {
            return this.myId;
        }

        public String getContent() {
            return this.myContent;
        }

        @NotNull
        private String getOldHistoryFilePath(String id) {
            String pathName = this.myRootType.getConsoleTypeId() + Long.toHexString(StringHash.calc((String)id));
            String string2 = PathManager.getSystemPath() + File.separator + "userHistory" + File.separator + pathName + ".hist.xml";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController$ModelHelper", "getOldHistoryFilePath"));
            }
            return string2;
        }

        public boolean loadHistory(String id, VirtualFile consoleFile) {
            try {
                VirtualFile file2;
                VirtualFile virtualFile = file2 = this.myRootType.isHidden() ? null : HistoryRootType.getInstance().findFile(null, ConsoleHistoryController.getHistoryName(this.myRootType, id), ScratchFileService.Option.existing_only);
                if (file2 == null) {
                    if (this.loadHistoryOld(id)) {
                        if (!this.myRootType.isHidden()) {
                            WriteAction.run(() -> VfsUtil.saveText((VirtualFile)consoleFile, (String)this.myContent));
                        }
                        return true;
                    }
                    return false;
                }
                String[] split = VfsUtilCore.loadText(file2).split(this.myRootType.getEntrySeparator());
                this.getModel().resetEntries(Arrays.asList(split));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean loadHistoryOld(String id) {
            File file2 = new File(PathUtil.toSystemDependentName((String)this.getOldHistoryFilePath(id)));
            if (!file2.exists()) {
                return false;
            }
            try (XppReader xmlReader = null;){
                xmlReader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
                String text2 = this.loadHistory((HierarchicalStreamReader)xmlReader, id);
                if (text2 != null) {
                    this.myContent = text2;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveHistoryOld() {
            File file2 = new File(PathUtil.toSystemDependentName((String)this.getOldHistoryFilePath(this.myId)));
            File dir = file2.getParentFile();
            if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
                LOG.error("failed to create folder: " + dir.getAbsolutePath());
                return;
            }
            SafeFileOutputStream os = null;
            try {
                os = new SafeFileOutputStream(file2);
                XmlSerializer serializer2 = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1.MXParserFactory", null).newSerializer();
                try {
                    serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serializer2.setOutput((OutputStream)os, "UTF-8");
                this.saveHistory(serializer2);
                serializer2.flush();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        private void saveHistory() {
            try {
                if (this.getModel().isEmpty()) {
                    return;
                }
                if (this.myRootType.isHidden()) {
                    this.saveHistoryOld();
                    return;
                }
                WriteAction.run(() -> {
                    VirtualFile file2 = HistoryRootType.getInstance().findFile(null, ConsoleHistoryController.getHistoryName(this.myRootType, this.myId), ScratchFileService.Option.create_if_missing);
                    VfsUtil.saveText((VirtualFile)file2, (String)StringUtil.join(this.getModel().getEntries(), (String)this.myRootType.getEntrySeparator()));
                });
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }

        @Nullable
        private String loadHistory(HierarchicalStreamReader in, String expectedId) {
            if (!in.getNodeName().equals("console-history")) {
                return null;
            }
            String id = in.getAttribute("id");
            if (!expectedId.equals(id)) {
                return null;
            }
            ArrayList entries = ContainerUtil.newArrayList();
            String consoleContent = null;
            while (in.hasMoreChildren()) {
                in.moveDown();
                if ("history-entry".equals(in.getNodeName())) {
                    entries.add(StringUtil.notNullize((String)in.getValue()));
                } else if ("console-content".equals(in.getNodeName())) {
                    consoleContent = StringUtil.notNullize((String)in.getValue());
                }
                in.moveUp();
            }
            this.getModel().resetEntries(entries);
            return consoleContent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveHistory(XmlSerializer out) throws IOException {
            out.startDocument("UTF-8", null);
            out.startTag(null, "console-history");
            out.attribute(null, "version", "1");
            out.attribute(null, "id", this.myId);
            try {
                for (String s2 : this.getModel().getEntries()) {
                    ConsoleHistoryController.textTag(out, "history-entry", s2);
                }
                String current = this.myContent;
                if (StringUtil.isNotEmpty((String)current)) {
                    ConsoleHistoryController.textTag(out, "console-content", current);
                }
            }
            finally {
                out.endTag(null, "console-history");
                out.endDocument();
            }
        }
    }

    private class MyBrowseAction
    extends DumbAwareAction {
        private MyBrowseAction() {
        }

        public void update(AnActionEvent e2) {
            boolean enabled = ConsoleHistoryController.this.hasHistory();
            e2.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e2) {
            String s1 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ConsoleHistoryController.this.myHistoryNext);
            String s2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ConsoleHistoryController.this.myHistoryPrev);
            String title = ConsoleHistoryController.this.myConsole.getTitle() + " History" + (StringUtil.isNotEmpty((String)s1) && StringUtil.isNotEmpty((String)s2) ? " (" + s1 + " and " + s2 + " while in editor)" : "");
            ContentChooser<String> chooser = new ContentChooser<String>(ConsoleHistoryController.this.myConsole.getProject(), title, true, true){

                @Override
                protected void removeContentAt(String content2) {
                    ConsoleHistoryController.this.getModel().removeFromHistory(content2);
                }

                @Override
                protected String getStringRepresentationFor(String content2) {
                    return content2;
                }

                @Override
                protected List<String> getContents() {
                    List<String> entries = ConsoleHistoryController.this.getModel().getEntries();
                    Collections.reverse(entries);
                    return entries;
                }

                @Override
                protected Editor createIdeaEditor(String text2) {
                    PsiFile consoleFile = ConsoleHistoryController.this.myConsole.getFile();
                    Language language = consoleFile.getLanguage();
                    Project project2 = consoleFile.getProject();
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("a." + consoleFile.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)new String(text2)), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    EditorEx editor = (EditorEx)editorFactory.createViewer(document, project2);
                    editor.getSettings().setFoldingOutlineShown(false);
                    editor.getSettings().setLineMarkerAreaShown(false);
                    editor.getSettings().setIndentGuidesShown(false);
                    SyntaxHighlighter highlighter2 = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)psiFile.getViewProvider().getVirtualFile());
                    editor.setHighlighter(new LexerEditorHighlighter(highlighter2, editor.getColorsScheme()));
                    return editor;
                }
            };
            chooser.setContentIcon(null);
            chooser.setSplitterOrientation(false);
            chooser.setSelectedIndex(Math.max(0, ConsoleHistoryController.this.getModel().getHistorySize() - ConsoleHistoryController.this.getModel().getCurrentIndex() - 1));
            if (chooser.showAndGet() && ConsoleHistoryController.this.myConsole.getCurrentEditor().getComponent().isShowing()) {
                ConsoleHistoryController.this.setConsoleText(chooser.getSelectedText(), false, true);
            }
        }
    }

    private class MyAction
    extends DumbAwareAction {
        private final boolean myNext;
        @NotNull
        private final Collection<KeyStroke> myUpDownKeystrokes;

        public MyAction(@NotNull boolean next, Collection<KeyStroke> upDownKeystrokes) {
            if (upDownKeystrokes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upDownKeystrokes", "com/intellij/execution/console/ConsoleHistoryController$MyAction", "<init>"));
            }
            this.myNext = next;
            this.myUpDownKeystrokes = upDownKeystrokes;
            this.getTemplatePresentation().setVisible(false);
        }

        public void actionPerformed(AnActionEvent e2) {
            String command;
            if (this.myNext) {
                command = ConsoleHistoryController.this.getModel().getHistoryNext();
                if (!ConsoleHistoryController.this.myMultiline && command == null) {
                    return;
                }
            } else {
                command = (String)ObjectUtils.chooseNotNull((Object)ConsoleHistoryController.this.getModel().getHistoryPrev(), (Object)(ConsoleHistoryController.this.myMultiline ? "" : StringUtil.notNullize((String)ConsoleHistoryController.this.myHelper.getContent())));
            }
            ConsoleHistoryController.this.setConsoleText(command, this.myNext && !ConsoleHistoryController.this.getModel().hasHistory(false), true);
        }

        public void update(AnActionEvent e2) {
            super.update(e2);
            boolean enabled = ConsoleHistoryController.this.myMultiline || !this.isUpDownKey(e2) || ConsoleHistoryController.this.canMoveInEditor(this.myNext);
            e2.getPresentation().setEnabled(enabled);
        }

        private boolean isUpDownKey(AnActionEvent e2) {
            InputEvent event = e2.getInputEvent();
            if (!(event instanceof KeyEvent)) {
                return false;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            return this.myUpDownKeystrokes.contains(keyStroke);
        }
    }
}

