/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleConfigurable;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldLinesLikeThis
extends DumbAwareAction {
    @Nullable
    private static String getSingleLineSelection(@NotNull Editor editor) {
        String selection;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/FoldLinesLikeThis", "getSingleLineSelection"));
        }
        SelectionModel model2 = editor.getSelectionModel();
        Document document = editor.getDocument();
        if (!model2.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            if (offset <= document.getTextLength()) {
                int lineNumber = document.getLineNumber(offset);
                String line = document.getText().substring(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)).trim();
                if (StringUtil.isNotEmpty((String)line)) {
                    return line;
                }
            }
            return null;
        }
        int start2 = model2.getSelectionStart();
        int end = model2.getSelectionEnd();
        if (document.getLineNumber(start2) == document.getLineNumber(end) && StringUtil.isNotEmpty((String)(selection = document.getText().substring(start2, end).trim()))) {
            return selection;
        }
        return null;
    }

    public void update(AnActionEvent e2) {
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        boolean enabled = e2.getData(LangDataKeys.CONSOLE_VIEW) != null && editor != null && FoldLinesLikeThis.getSingleLineSelection(editor) != null;
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e2) {
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        assert (editor != null);
        final String selection = FoldLinesLikeThis.getSingleLineSelection(editor);
        assert (selection != null);
        ShowSettingsUtil.getInstance().editConfigurable(editor.getProject(), (Configurable)new ConsoleConfigurable(){

            @Override
            protected boolean editFoldingsOnly() {
                return true;
            }

            @Override
            public void reset() {
                super.reset();
                UIUtil.invokeLaterIfNeeded(() -> this.addRule(selection));
            }
        });
        ConsoleView consoleView = (ConsoleView)e2.getData(LangDataKeys.CONSOLE_VIEW);
        if (consoleView instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)consoleView).foldImmediately();
        }
    }
}

