/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;

public class RunIdeConsoleAction
extends DumbAwareAction {
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<WeakReference<RunContentDescriptor>> DESCRIPTOR_KEY = Key.create((String)"DESCRIPTOR_KEY");
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);

    public void update(AnActionEvent e2) {
        IdeScriptEngineManager manager = IdeScriptEngineManager.getInstance();
        e2.getPresentation().setVisible(e2.getProject() != null);
        e2.getPresentation().setEnabled(manager.isInitialized() && !manager.getLanguages().isEmpty());
    }

    public void actionPerformed(AnActionEvent e2) {
        List<String> languages = IdeScriptEngineManager.getInstance().getLanguages();
        if (languages.size() == 1) {
            this.runConsole(e2, languages.iterator().next());
            return;
        }
        DefaultActionGroup actions2 = new DefaultActionGroup(ContainerUtil.map(languages, (Function)((NotNullFunction)language -> new DumbAwareAction((String)language, (String)language){
            final /* synthetic */ String val$language;
            {
                this.val$language = string2;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e1) {
                if (e1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/execution/console/RunIdeConsoleAction$1", "actionPerformed"));
                }
                RunIdeConsoleAction.this.runConsole(e1, this.val$language);
            }
        })));
        JBPopupFactory.getInstance().createActionGroupPopup("Script Engine", (ActionGroup)actions2, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e2.getDataContext());
    }

    protected void runConsole(@NotNull AnActionEvent e2, @NotNull String language) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        List<String> extensions = IdeScriptEngineManager.getInstance().getFileExtensions(language);
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project2, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project2).openFile(virtualFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull IdeScriptEngine engine) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        String command = RunIdeConsoleAction.getCommandText(project2, editor);
        if (StringUtil.isEmptyOrSpaces((String)command)) {
            return;
        }
        String profile2 = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor2 = RunIdeConsoleAction.getConsoleView(project2, file2);
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor2.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project2, engine, descriptor2);
        try {
            long ts = System.currentTimeMillis();
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile2 == null ? command : profile2 + "\n" + command;
            Object o2 = engine.eval(script);
            String prefix = "[" + StringUtil.formatDuration((long)(System.currentTimeMillis() - ts)) + "]";
            consoleView.print(prefix + "=> " + o2, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e2) {
            Throwable ex = ExceptionUtil.getRootCause((Throwable)e2);
            consoleView.print(ex.getClass().getSimpleName() + ": " + ex.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor2);
    }

    private static void prepareEngine(@NotNull Project project2, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        IdeConsoleScriptBindings.ensureIdeIsBound(project2, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor2);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "getProfileText"));
        }
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize((String)VfsUtilCore.loadText(profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "getCommandText"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/RunIdeConsoleAction", "getCommandText"));
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.isEmpty()) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 != null && file2.getFirstChild() != null && file2.getFirstChild() != file2.getLastChild()) {
                PsiElement parent;
                PsiElement e1 = file2.findElementAt(selectedRange.getStartOffset());
                PsiElement e2 = file2.findElementAt(selectedRange.getEndOffset());
                while (e1 != e2 && (e1 instanceof PsiWhiteSpace || e1 != null && StringUtil.isEmptyOrSpaces((String)e1.getText()))) {
                    e1 = (PsiElement)ObjectUtils.chooseNotNull((Object)e1.getNextSibling(), (Object)PsiTreeUtil.getDeepestFirst((PsiElement)e1.getParent()));
                }
                while (e1 != e2 && (e2 instanceof PsiWhiteSpace || e2 != null && StringUtil.isEmptyOrSpaces((String)e2.getText()))) {
                    e2 = (PsiElement)ObjectUtils.chooseNotNull((Object)e2.getPrevSibling(), (Object)PsiTreeUtil.getDeepestLast((PsiElement)e2.getParent()));
                }
                if (e1 instanceof LeafPsiElement) {
                    e1 = e1.getParent();
                }
                if (e2 instanceof LeafPsiElement) {
                    e2 = e2.getParent();
                }
                PsiElement psiElement = e1 == null ? e2 : (parent = e2 == null ? e1 : PsiTreeUtil.findCommonParent((PsiElement)e1, (PsiElement)e2));
                if (parent != null && parent != file2) {
                    selectedRange = parent.getTextRange();
                }
            }
        }
        String string2 = document.getText(selectedRange);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getCommandText"));
        }
        return string2;
    }

    private static void selectContent(RunContentDescriptor descriptor2) {
        Executor executor2 = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = (ConsoleViewImpl)ObjectUtils.assertNotNull((Object)((ConsoleViewImpl)descriptor2.getExecutionConsole()));
        ExecutionManager.getInstance((Project)consoleView.getProject()).getContentManager().toFrontRunContent(executor2, descriptor2);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project2, @NotNull VirtualFile file2) {
        RunContentDescriptor descriptor2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.assertNotNull((Object)PsiManager.getInstance((Project)project2).findFile(file2));
        WeakReference ref = (WeakReference)psiFile.getCopyableUserData(DESCRIPTOR_KEY);
        RunContentDescriptor runContentDescriptor = descriptor2 = ref == null ? null : (RunContentDescriptor)ref.get();
        if (descriptor2 == null || descriptor2.getExecutionConsole() == null) {
            descriptor2 = RunIdeConsoleAction.createConsoleView(project2, psiFile);
            psiFile.putCopyableUserData(DESCRIPTOR_KEY, new WeakReference<RunContentDescriptor>(descriptor2));
        }
        RunContentDescriptor runContentDescriptor2 = descriptor2;
        if (runContentDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        return runContentDescriptor2;
    }

    @NotNull
    private static RunContentDescriptor createConsoleView(@NotNull Project project2, @NotNull PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
        DefaultActionGroup toolbarActions2 = new DefaultActionGroup();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions2, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel2.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel2, psiFile.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor2 = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions2.addAll(consoleView.createConsoleActions());
        toolbarActions2.add((AnAction)new CloseAction(executor2, descriptor2, project2));
        ExecutionManager.getInstance((Project)project2).getContentManager().showRunContent(executor2, descriptor2);
        RunContentDescriptor runContentDescriptor = descriptor2;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        return runContentDescriptor;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "ensureOutputIsRedirected"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction", "ensureOutputIsRedirected"));
        }
        ConsoleWriter stdOutWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor2 && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor2) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor2);
        engine.setStdOut(new ConsoleWriter(ref, ConsoleViewContentType.NORMAL_OUTPUT));
        engine.setStdErr(new ConsoleWriter(ref, ConsoleViewContentType.ERROR_OUTPUT));
    }

    private static class ConsoleWriter
    extends Writer {
        private final WeakReference<RunContentDescriptor> myDescriptor;
        private final ConsoleViewContentType myOutputType;

        private ConsoleWriter(@NotNull WeakReference<RunContentDescriptor> descriptor2, @NotNull ConsoleViewContentType outputType) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter", "<init>"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter", "<init>"));
            }
            this.myDescriptor = descriptor2;
            this.myOutputType = outputType;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return (RunContentDescriptor)this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RunContentDescriptor descriptor2 = (RunContentDescriptor)this.myDescriptor.get();
            ConsoleViewImpl console = (ConsoleViewImpl)ObjectUtils.tryCast((Object)(descriptor2 != null ? descriptor2.getExecutionConsole() : null), ConsoleViewImpl.class);
            if (console == null) {
                throw new IOException("The console is not available.");
            }
            console.print(new String(cbuf, off, len), this.myOutputType);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngine engine;

        private MyRunAction() {
        }

        public void update(AnActionEvent e2) {
            Project project2 = e2.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e2.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e2.getDataContext());
            e2.getPresentation().setEnabledAndVisible(project2 != null && editor != null && virtualFile != null);
        }

        public void actionPerformed(AnActionEvent e2) {
            Project project2 = e2.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e2.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e2.getDataContext());
            if (project2 == null || editor == null || virtualFile == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            String extension = virtualFile.getExtension();
            if (!(extension == null || this.engine != null && this.engine.getFileExtensions().contains(extension))) {
                this.engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension(extension, null);
            }
            if (this.engine == null) {
                LOG.warn("Script engine not found for: " + virtualFile.getName());
            } else {
                RunIdeConsoleAction.executeQuery(project2, virtualFile, editor, this.engine);
            }
        }
    }
}

