/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.DashboardGroupingRule;
import com.intellij.execution.dashboard.DashboardListener;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final List<DashboardGrouper> myGroupers;
    private RunDashboardContent myDashboardContent;

    public RunDashboardManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/RunDashboardManagerImpl", "<init>"));
        }
        this.myProject = project2;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        PanelContentUI contentUI = new PanelContentUI();
        this.myContentManager = contentFactory.createContentManager((ContentUI)contentUI, false, project2);
        this.myGroupers = Arrays.stream(DashboardGroupingRule.EP_NAME.getExtensions()).sorted(DashboardGroupingRule.PRIORITY_COMPARATOR).map(DashboardGrouper::new).collect(Collectors.toList());
        if (RunDashboardManagerImpl.isDashboardEnabled()) {
            this.initToolWindowListeners();
        }
    }

    private static boolean isDashboardEnabled() {
        return Registry.is((String)"ide.run.dashboard") && ((RunDashboardContributor[])RunDashboardContributor.EP_NAME.getExtensions()).length > 0;
    }

    private void initToolWindowListeners() {
        RunManagerEx.getInstanceEx(this.myProject).addRunManagerListener(new RunManagerListener(){

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationAdded"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationRemoved"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationChanged"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }
        });
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new DashboardListener(){

            public void contentChanged(boolean withStructure) {
                RunDashboardManagerImpl.this.updateDashboard(withStructure);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return ToolWindowId.RUN_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    public boolean isToolWindowAvailable() {
        return RunDashboardManagerImpl.isDashboardEnabled() && this.hasContent();
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/execution/dashboard/RunDashboardManagerImpl", "createToolWindowContent"));
        }
        this.myDashboardContent = new RunDashboardContent(this.myProject, this.myContentManager, this.myGroupers);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content2 = contentManager.getFactory().createContent((JComponent)this.myDashboardContent, null, false);
        Disposer.register((Disposable)content2, (Disposable)this.myDashboardContent);
        Disposer.register((Disposable)content2, () -> {
            this.myDashboardContent = null;
        });
        toolWindow.getContentManager().addContent(content2);
    }

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations() {
        ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> result2 = new ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>>();
        List<RunnerAndConfigurationSettings> configurations = RunManager.getInstance((Project)this.myProject).getAllSettings().stream().filter(runConfiguration -> RunDashboardContributor.isShowInDashboard((ConfigurationType)runConfiguration.getType())).collect(Collectors.toList());
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        configurations.forEach(configurationSettings -> {
            List<RunContentDescriptor> descriptors = executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> Comparing.equal((Object)settings.getConfiguration(), (Object)configurationSettings.getConfiguration())));
            if (descriptors.isEmpty()) {
                result2.add(Pair.create((Object)configurationSettings, null));
            } else {
                descriptors.forEach(descriptor2 -> result2.add(Pair.create((Object)configurationSettings, (Object)descriptor2)));
            }
        });
        List storedConfigurations = configurations.stream().map(RunnerAndConfigurationSettings::getConfiguration).collect(Collectors.toList());
        List<RunContentDescriptor> notStoredDescriptors = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> {
            RunConfiguration configuration = settings.getConfiguration();
            return RunDashboardContributor.isShowInDashboard((ConfigurationType)settings.getType()) && !storedConfigurations.contains(configuration);
        }));
        notStoredDescriptors.forEach(descriptor2 -> {
            Set<RunnerAndConfigurationSettings> settings = executionManager.getConfigurations((RunContentDescriptor)descriptor2);
            settings.forEach(setting -> result2.add(Pair.create((Object)setting, (Object)descriptor2)));
        });
        return result2;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null && RunDashboardContributor.isShowInDashboard((ConfigurationType)settings.getType())) {
            this.updateDashboard(true);
        }
    }

    private void updateDashboard(boolean withStructure) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (withStructure) {
                boolean available = this.hasContent();
                ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
                if (toolWindow == null) {
                    if (available) {
                        this.createToolWindow();
                    }
                    return;
                }
                boolean doShow = !toolWindow.isAvailable() && available;
                toolWindow.setAvailable(available, null);
                if (doShow) {
                    toolWindow.show(null);
                }
            }
            if (this.myDashboardContent != null) {
                this.myDashboardContent.updateContent(withStructure);
            }
        });
    }

    private void createToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), false, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        this.createToolWindowContent(toolWindow);
    }

    private boolean hasContent() {
        return !this.getRunConfigurations().isEmpty();
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.ruleStates = this.myGroupers.stream().filter(grouper -> !grouper.getRule().isAlwaysEnabled()).map(grouper -> new RuleState(grouper.getRule().getName(), grouper.isEnabled())).collect(Collectors.toList());
        return state;
    }

    public void loadState(State state) {
        state.ruleStates.forEach(ruleState -> {
            for (DashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                return;
            }
        });
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        public RuleState() {
        }

        public RuleState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }
    }

    static class State {
        public List<RuleState> ruleStates = new ArrayList<RuleState>();

        State() {
        }
    }
}

