/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.actions.RunDashboardTreeAction;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class RunDashboardTreeLeafAction<T extends DashboardNode>
extends RunDashboardTreeAction<T> {
    protected RunDashboardTreeLeafAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
    }

    protected final boolean isMultiSelectionAllowed() {
        return true;
    }

    @NotNull
    protected Set<?> collectNodes(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeBuilder", "com/intellij/execution/dashboard/actions/RunDashboardTreeLeafAction", "collectNodes"));
        }
        Set selectedElement = treeBuilder.getSelectedElements();
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
        for (Object o2 : selectedElement) {
            if (!(o2 instanceof AbstractTreeNode)) {
                Set set2 = Collections.emptySet();
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/actions/RunDashboardTreeLeafAction", "collectNodes"));
                }
                return set2;
            }
            nodes.add((AbstractTreeNode)o2);
        }
        Set<AbstractTreeNode> set3 = RunDashboardTreeLeafAction.getLeaves(nodes);
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/actions/RunDashboardTreeLeafAction", "collectNodes"));
        }
        return set3;
    }

    private static Set<AbstractTreeNode> getLeaves(Collection<? extends AbstractTreeNode> nodes) {
        HashSet<AbstractTreeNode> result2 = new HashSet<AbstractTreeNode>();
        for (AbstractTreeNode abstractTreeNode : nodes) {
            Collection children2 = abstractTreeNode.getChildren();
            if (children2.isEmpty()) {
                if (abstractTreeNode instanceof GroupingNode) continue;
                result2.add(abstractTreeNode);
                continue;
            }
            result2.addAll(RunDashboardTreeLeafAction.getLeaves(children2));
        }
        return result2;
    }
}

