/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public abstract class AbstractFileHyperlinkFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance(AbstractFileHyperlinkFilter.class);
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;
    private final VirtualFile myBaseDir;

    public AbstractFileHyperlinkFilter(@NotNull Project project2, @Nullable String baseDir) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/AbstractFileHyperlinkFilter", "<init>"));
        }
        this(project2, AbstractFileHyperlinkFilter.findDir(baseDir));
    }

    public AbstractFileHyperlinkFilter(@NotNull Project project2, @Nullable VirtualFile baseDir) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/AbstractFileHyperlinkFilter", "<init>"));
        }
        this.myProject = project2;
        this.myFileIndex = ProjectFileIndex.getInstance((Project)project2);
        this.myBaseDir = baseDir;
    }

    @Nullable
    protected static VirtualFile findDir(@Nullable String baseDir) {
        if (baseDir == null) {
            return null;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            String path = FileUtil.toSystemIndependentName((String)baseDir);
            VirtualFile dir = LocalFileFinder.findFile(path);
            return dir != null && dir.isValid() && dir.isDirectory() ? dir : null;
        });
    }

    protected boolean supportVfsRefresh() {
        return false;
    }

    @Nullable
    public final Filter.Result applyFilter(String line, int entireLength) {
        List<FileHyperlinkRawData> links;
        try {
            links = this.parse(line);
        }
        catch (RuntimeException e2) {
            LOG.error("Failed to parse '" + line + "' with " + this.getClass(), (Throwable)e2);
            return null;
        }
        ArrayList items2 = ContainerUtil.newArrayList();
        for (FileHyperlinkRawData link : links) {
            File ioFile;
            String filePath = FileUtil.toSystemIndependentName((String)link.getFilePath());
            if (StringUtil.isEmptyOrSpaces((String)filePath)) continue;
            VirtualFile file2 = this.findFile(filePath);
            Object info = null;
            boolean grayedHyperLink = false;
            if (file2 != null) {
                info = new OpenFileHyperlinkInfo(this.myProject, file2, link.getDocumentLine(), link.getDocumentColumn());
                grayedHyperLink = this.isGrayedHyperlink(file2);
            } else if (this.supportVfsRefresh() && (ioFile = this.findIoFile(filePath)) != null) {
                info = new MyFileHyperlinkInfo(ioFile, link.getDocumentLine(), link.getDocumentColumn());
            }
            if (info == null) continue;
            int offset = entireLength - line.length();
            items2.add(new Filter.ResultItem(offset + link.getHyperlinkStartInd(), offset + link.getHyperlinkEndInd(), (HyperlinkInfo)info, grayedHyperLink));
        }
        return items2.isEmpty() ? null : new Filter.Result((List)items2);
    }

    @Nullable
    private File findIoFile(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/filters/AbstractFileHyperlinkFilter", "findIoFile"));
        }
        File ioFile = new File(filePath);
        if (ioFile.isAbsolute() && ioFile.isFile()) {
            return ioFile;
        }
        ioFile = new File(this.myBaseDir.getPath(), filePath);
        return ioFile.isFile() ? ioFile : null;
    }

    private boolean isGrayedHyperlink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/filters/AbstractFileHyperlinkFilter", "isGrayedHyperlink"));
        }
        return !this.myFileIndex.isInContent(file2) || this.myFileIndex.isInLibrary(file2);
    }

    @NotNull
    public abstract List<FileHyperlinkRawData> parse(@NotNull String var1);

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/filters/AbstractFileHyperlinkFilter", "findFile"));
        }
        VirtualFile file2 = LocalFileFinder.findFile(filePath);
        if (file2 == null && this.myBaseDir != null) {
            file2 = this.myBaseDir.findFileByRelativePath(filePath);
        }
        return file2;
    }

    private static class MyFileHyperlinkInfo
    implements HyperlinkInfo {
        private final File myIoFile;
        private final int myDocumentLine;
        private final int myDocumentColumn;
        private Ref<VirtualFile> myFileRef;

        public MyFileHyperlinkInfo(@NotNull File ioFile, int documentLine, int documentColumn) {
            if (ioFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/execution/filters/AbstractFileHyperlinkFilter$MyFileHyperlinkInfo", "<init>"));
            }
            this.myIoFile = ioFile;
            this.myDocumentLine = documentLine;
            this.myDocumentColumn = documentColumn;
        }

        public void navigate(Project project2) {
            Ref fileRef = this.myFileRef;
            if (fileRef == null) {
                VirtualFile file2 = (VirtualFile)WriteAction.compute(() -> VfsUtil.findFileByIoFile((File)this.myIoFile, (boolean)true));
                this.myFileRef = fileRef = Ref.create((Object)file2);
            }
            if (fileRef.get() != null) {
                OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(project2, (VirtualFile)fileRef.get(), this.myDocumentLine, this.myDocumentColumn);
                linkInfo.navigate(project2);
            }
        }
    }
}

