/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.FilterRunner");
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"console filters", (int)1);
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private final Queue<LineHighlighter> myQueue = new ConcurrentLinkedQueue<LineHighlighter>();
    @NotNull
    private List<FilterResult> myResults = new ArrayList<FilterResult>();

    AsyncFilterRunner(EditorHyperlinkSupport hyperlinks, Editor editor) {
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    void highlightHyperlinks(Filter customFilter, int startLine, int endLine) {
        if (endLine < 0) {
            return;
        }
        this.queueTasks(customFilter, startLine, endLine);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.runTasks();
            this.highlightAvailableResults();
        } else if (AsyncFilterRunner.isQuick(ourExecutor.submit(this::runFiltersInBackground))) {
            this.highlightAvailableResults();
        }
    }

    private void runFiltersInBackground() {
        while (true) {
            boolean finished2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(this::runTasks);
            if (this.hasResults()) {
                ApplicationManager.getApplication().invokeLater(this::highlightAvailableResults, ModalityState.any());
            }
            if (finished2) {
                return;
            }
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
    }

    private static boolean isQuick(Future<?> future2) {
        try {
            future2.get(5L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void highlightAvailableResults() {
        for (FilterResult result2 : this.takeAvailableResults()) {
            result2.applyHighlights();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResults() {
        Queue<LineHighlighter> queue2 = this.myQueue;
        synchronized (queue2) {
            return !this.myResults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<FilterResult> takeAvailableResults() {
        Queue<LineHighlighter> queue2 = this.myQueue;
        // MONITORENTER : queue2
        List<FilterResult> results = this.myResults;
        this.myResults = new ArrayList<FilterResult>();
        List<FilterResult> list2 = results;
        // MONITOREXIT : queue2
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "takeAvailableResults"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLineResult(@Nullable FilterResult result2) {
        if (result2 == null) {
            return;
        }
        Queue<LineHighlighter> queue2 = this.myQueue;
        synchronized (queue2) {
            this.myResults.add(result2);
        }
    }

    public boolean waitForPendingFilters(long timeoutMs) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long started = System.currentTimeMillis();
        while (true) {
            if (this.myQueue.isEmpty()) {
                this.highlightAvailableResults();
                return true;
            }
            if (this.hasResults()) {
                this.highlightAvailableResults();
                continue;
            }
            if (System.currentTimeMillis() - started > timeoutMs) {
                return false;
            }
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void queueTasks(Filter filter2, int startLine, int endLine) {
        Document document = this.myEditor.getDocument();
        int markerOffset = document.getLineEndOffset(endLine);
        RangeMarker marker = document.createRangeMarker(markerOffset, markerOffset);
        for (int line = startLine; line <= endLine; ++line) {
            this.myQueue.offer(this.processLine(document, filter2, line, markerOffset, marker));
        }
    }

    @NotNull
    private LineHighlighter processLine(Document document, Filter filter2, int line, int initialMarkerOffset, RangeMarker marker) {
        int lineEnd;
        int endOffset = lineEnd + ((lineEnd = document.getLineEndOffset(line)) < document.getTextLength() ? 1 : 0);
        CharSequence text2 = EditorHyperlinkSupport.getLineSequence(document, line, true);
        LineHighlighter lineHighlighter = () -> this.runFilterForLine(initialMarkerOffset, marker, filter2, endOffset, text2);
        if (lineHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "processLine"));
        }
        return lineHighlighter;
    }

    @Nullable
    private FilterResult runFilterForLine(int initialMarkerOffset, RangeMarker marker, Filter filter2, int endOffset, CharSequence lineText) {
        if (!marker.isValid() || marker.getEndOffset() == 0) {
            return null;
        }
        Filter.Result result2 = AsyncFilterRunner.checkRange(filter2, endOffset, filter2.applyFilter(lineText.toString(), endOffset));
        return result2 == null ? null : () -> {
            if (marker.isValid()) {
                this.myHyperlinks.highlightHyperlinks(result2, marker.getStartOffset() - initialMarkerOffset);
            }
        };
    }

    private void runTasks() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        while (!this.myQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            LineHighlighter highlighter2 = this.myQueue.peek();
            this.addLineResult(highlighter2.runFilterForLine());
            LOG.assertTrue(highlighter2 == this.myQueue.remove());
        }
    }

    private static Filter.Result checkRange(Filter filter2, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start2 = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start2 && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start2 + "; end=" + end + "; max=" + endOffset + "; filter=" + filter2);
            }
        }
        return result2;
    }

    private static interface FilterResult {
        public void applyHighlights();
    }

    private static interface LineHighlighter {
        @Nullable
        public FilterResult runFilterForLine();
    }
}

