/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.StringSetSpinAllocator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class BaseExecuteBeforeRunDialog<T extends BeforeRunTask>
extends DialogWrapper {
    private final Project myProject;
    private DefaultMutableTreeNode myRoot;

    public BaseExecuteBeforeRunDialog(Project project2) {
        super(project2, true);
        this.myProject = project2;
    }

    protected void init() {
        super.init();
        this.setTitle(ExecutionBundle.message((String)"execute.before.run.debug.dialog.title", (Object[])new Object[]{this.getTargetDisplayString()}));
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myRoot = this.buildNodes();
        final Tree tree2 = new Tree((TreeNode)this.myRoot);
        final MyTreeCellRenderer cellRenderer = new MyTreeCellRenderer();
        tree2.setCellRenderer((TreeCellRenderer)cellRenderer);
        tree2.setRootVisible(false);
        tree2.setShowsRootHandles(true);
        tree2.setLineStyleAngled();
        TreeUtil.installActions((JTree)tree2);
        new TreeSpeedSearch((JTree)tree2);
        tree2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                int row = tree2.getRowForLocation(e2.getX(), e2.getY());
                if (row >= 0) {
                    Rectangle rowBounds = tree2.getRowBounds(row);
                    cellRenderer.setBounds(rowBounds);
                    Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                    checkBounds.setLocation(rowBounds.getLocation());
                    if (checkBounds.contains(e2.getPoint())) {
                        BaseExecuteBeforeRunDialog.toggleNode((JTree)tree2, (DefaultMutableTreeNode)tree2.getPathForRow(row).getLastPathComponent());
                        e2.consume();
                        tree2.setSelectionRow(row);
                    }
                }
            }
        });
        tree2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 32) {
                    TreePath treePath = tree2.getLeadSelectionPath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    BaseExecuteBeforeRunDialog.toggleNode((JTree)tree2, node);
                    e2.consume();
                }
            }
        });
        BaseExecuteBeforeRunDialog.expacndChecked(tree2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree2);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        panel2.add((Component)scrollPane, "Center");
        return panel2;
    }

    private static void expacndChecked(Tree tree2) {
        TreeNode root = (TreeNode)tree2.getModel().getRoot();
        Enumeration<? extends TreeNode> factories = root.children();
        ArrayList<TreeNode[]> toExpand = new ArrayList<TreeNode[]>();
        block0: while (factories.hasMoreElements()) {
            DefaultMutableTreeNode factoryNode = (DefaultMutableTreeNode)factories.nextElement();
            Enumeration<TreeNode> enumeration = factoryNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                ConfigurationDescriptor config = (ConfigurationDescriptor)node.getUserObject();
                if (!config.isChecked()) continue;
                toExpand.add(factoryNode.getPath());
                continue block0;
            }
        }
        for (Object[] objectArray : toExpand) {
            tree2.expandPath(new TreePath(objectArray));
        }
    }

    private static void toggleNode(JTree tree2, DefaultMutableTreeNode node) {
        Descriptor descriptor2;
        descriptor2.setChecked(!(descriptor2 = (Descriptor)node.getUserObject()).isChecked());
        tree2.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode buildNodes() {
        ConfigurationType[] configTypes;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new Descriptor());
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (ConfigurationType type : configTypes = runManager.getConfigurationFactories()) {
            Icon icon = type.getIcon();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(new ConfigurationTypeDescriptor(type, icon, this.isConfigurationAssigned(type)));
            root.add(typeNode);
            Set addedNames = StringSetSpinAllocator.alloc();
            try {
                List configurations = runManager.getConfigurationsList(type);
                for (RunConfiguration configuration : configurations) {
                    String configurationName = configuration.getName();
                    if (addedNames.contains(configurationName)) continue;
                    addedNames.add(configurationName);
                    typeNode.add(new DefaultMutableTreeNode(new ConfigurationDescriptor(configuration, this.isConfigurationAssigned(configuration))));
                }
            }
            finally {
                StringSetSpinAllocator.dispose((Set)addedNames);
            }
        }
        return root;
    }

    private boolean isConfigurationAssigned(ConfigurationType type) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx(this.myProject);
        for (ConfigurationFactory factory2 : type.getConfigurationFactories()) {
            RunnerAndConfigurationSettings settings = ((RunManagerImpl)runManager).getConfigurationTemplate(factory2);
            if (!this.isConfigurationAssigned(settings.getConfiguration())) continue;
            return true;
        }
        return false;
    }

    private boolean isConfigurationAssigned(RunConfiguration configuration) {
        List<T> tasks = RunManagerEx.getInstanceEx(this.myProject).getBeforeRunTasks(configuration, this.getTaskID());
        for (BeforeRunTask task2 : tasks) {
            if (!this.isRunning(task2)) continue;
            return true;
        }
        return false;
    }

    protected void doOKAction() {
        RunManagerImpl runManager = (RunManagerImpl)RunManagerEx.getInstanceEx(this.myProject);
        Enumeration<TreeNode> nodes = this.myRoot.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Descriptor descriptor2 = (Descriptor)node.getUserObject();
            boolean isChecked = descriptor2.isChecked();
            if (descriptor2 instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor typeDesc = (ConfigurationTypeDescriptor)descriptor2;
                for (ConfigurationFactory factory2 : typeDesc.getConfigurationType().getConfigurationFactories()) {
                    RunnerAndConfigurationSettings settings = runManager.getConfigurationTemplate(factory2);
                    this.update(settings.getConfiguration(), isChecked, runManager);
                }
                continue;
            }
            if (!(descriptor2 instanceof ConfigurationDescriptor)) continue;
            ConfigurationDescriptor configDesc = (ConfigurationDescriptor)descriptor2;
            this.update(configDesc.getConfiguration(), isChecked, runManager);
        }
        RunManagerImpl.getInstanceImpl(this.myProject).fireBeforeRunTasksUpdated();
        this.close(0);
    }

    protected abstract String getTargetDisplayString();

    protected abstract Key<T> getTaskID();

    protected abstract boolean isRunning(T var1);

    private void update(RunConfiguration config, boolean enabled, RunManagerImpl runManager) {
        List<BeforeRunTask> tasks = runManager.getBeforeRunTasks(config);
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, this.getTaskID());
        if (provider == null) {
            return;
        }
        BeforeRunTask task2 = provider.createTask(config);
        this.update(task2);
        task2.setEnabled(true);
        if (enabled) {
            if (!tasks.contains(task2)) {
                tasks.add(task2);
            }
        } else if (tasks.contains(task2)) {
            tasks.remove(task2);
        }
        runManager.setBeforeRunTasks(config, tasks, false);
    }

    protected abstract void update(T var1);

    protected abstract void clear(T var1);

    private static final class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final JLabel myLabel;
        public final JCheckBox myCheckbox = new JCheckBox();

        public MyTreeCellRenderer() {
            super(new BorderLayout());
            this.myLabel = new JLabel();
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myLabel, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Descriptor descriptor2 = (Descriptor)node.getUserObject();
            this.myCheckbox.setSelected(descriptor2.isChecked());
            this.myCheckbox.setBackground(UIUtil.getTreeTextBackground());
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground());
            Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
            this.setForeground(foreground);
            this.myCheckbox.setForeground(foreground);
            this.myLabel.setForeground(foreground);
            this.myCheckbox.setEnabled(true);
            if (descriptor2 instanceof ConfigurationTypeDescriptor) {
                ConfigurationTypeDescriptor configurationTypeDescriptor = (ConfigurationTypeDescriptor)descriptor2;
                this.myLabel.setFont(tree2.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getConfigurationType().getDisplayName());
                this.myLabel.setIcon(configurationTypeDescriptor.getIcon());
            } else if (descriptor2 instanceof ConfigurationDescriptor) {
                ConfigurationDescriptor configurationTypeDescriptor = (ConfigurationDescriptor)descriptor2;
                this.myLabel.setFont(tree2.getFont());
                this.myLabel.setText(configurationTypeDescriptor.getName());
                this.myLabel.setIcon(null);
                if (((ConfigurationTypeDescriptor)((DefaultMutableTreeNode)node.getParent()).getUserObject()).isChecked()) {
                    Color foregrnd = tree2.getForeground();
                    Color backgrnd = tree2.getBackground();
                    if (foregrnd == null) {
                        foregrnd = Color.black;
                    }
                    if (backgrnd == null) {
                        backgrnd = Color.white;
                    }
                    int red = (foregrnd.getRed() + backgrnd.getRed()) / 2;
                    int green = (foregrnd.getGreen() + backgrnd.getGreen()) / 2;
                    int blue = (foregrnd.getBlue() + backgrnd.getBlue()) / 2;
                    Color halftone = new Color(red, green, blue);
                    this.setForeground(halftone);
                    this.myCheckbox.setForeground(halftone);
                    this.myLabel.setForeground(halftone);
                    this.myCheckbox.setEnabled(false);
                }
            }
            return this;
        }
    }

    private static final class ConfigurationDescriptor
    extends Descriptor {
        private final RunConfiguration myConfiguration;

        public ConfigurationDescriptor(RunConfiguration configuration, boolean isChecked) {
            this.myConfiguration = configuration;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationFactory() {
            return this.myConfiguration.getType();
        }

        public String getName() {
            return this.myConfiguration.getName();
        }

        public RunConfiguration getConfiguration() {
            return this.myConfiguration;
        }
    }

    private static final class ConfigurationTypeDescriptor
    extends Descriptor {
        private final ConfigurationType myConfigurationType;
        private final Icon myIcon;

        public ConfigurationTypeDescriptor(ConfigurationType type, Icon icon, boolean isChecked) {
            this.myConfigurationType = type;
            this.myIcon = icon;
            this.setChecked(isChecked);
        }

        public ConfigurationType getConfigurationType() {
            return this.myConfigurationType;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static class Descriptor {
        private boolean myChecked;

        private Descriptor() {
        }

        public final boolean isChecked() {
            return this.myChecked;
        }

        public final void setChecked(boolean checked) {
            this.myChecked = checked;
        }
    }
}

