/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.BeforeRunStepsPanel;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HideableDecorator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationSettingsEditorWrapper
extends SettingsEditor<RunnerAndConfigurationSettings>
implements BeforeRunStepsPanel.StepsBeforeRunListener {
    public static final DataKey<ConfigurationSettingsEditorWrapper> CONFIGURATION_EDITOR_KEY = DataKey.create((String)"ConfigurationSettingsEditor");
    @NonNls
    private static final String EXPAND_PROPERTY_KEY = "ExpandBeforeRunStepsPanel";
    private JPanel myComponentPlace;
    private JPanel myWholePanel;
    private JPanel myBeforeLaunchContainer;
    private final BeforeRunStepsPanel myBeforeRunStepsPanel;
    private final ConfigurationSettingsEditor myEditor;
    private final HideableDecorator myDecorator;

    public <T extends SettingsEditor> T selectExecutorAndGetEditor(ProgramRunner runner, Class<T> editorClass) {
        return this.myEditor.selectExecutorAndGetEditor(runner, editorClass);
    }

    public <T extends SettingsEditor> T selectTabAndGetEditor(Class<T> editorClass) {
        return this.myEditor.selectTabAndGetEditor(editorClass);
    }

    public ConfigurationSettingsEditorWrapper(RunnerAndConfigurationSettings settings) {
        this.$$$setupUI$$$();
        this.myEditor = new ConfigurationSettingsEditor(settings);
        Disposer.register((Disposable)this, (Disposable)this.myEditor);
        this.myBeforeRunStepsPanel = new BeforeRunStepsPanel(this);
        this.myDecorator = new HideableDecorator(this.myBeforeLaunchContainer, "", false){

            @Override
            protected void on() {
                super.on();
                this.storeState();
            }

            @Override
            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(ConfigurationSettingsEditorWrapper.EXPAND_PROPERTY_KEY, String.valueOf(this.isExpanded()));
            }
        };
        this.myDecorator.setOn(PropertiesComponent.getInstance().getBoolean(EXPAND_PROPERTY_KEY, true));
        this.myDecorator.setContentComponent(this.myBeforeRunStepsPanel);
        this.doReset(settings);
    }

    private void doReset(RunnerAndConfigurationSettings settings) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        this.myBeforeRunStepsPanel.doReset(settings);
        this.myBeforeLaunchContainer.setVisible(!(runConfiguration instanceof WithoutOwnBeforeRunSteps));
    }

    @NotNull
    protected JComponent createEditor() {
        this.myComponentPlace.setLayout(new BorderLayout());
        this.myComponentPlace.add((Component)this.myEditor.getComponent(), "Center");
        DataManager.registerDataProvider((JComponent)this.myWholePanel, (DataProvider)new MyDataProvider());
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper", "createEditor"));
        }
        return jPanel;
    }

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper", "resetEditorFrom"));
        }
        this.myEditor.resetEditorFrom(settings);
        this.doReset(settings);
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper", "applyEditorTo"));
        }
        this.myEditor.applyEditorTo(settings);
        this.doApply(settings);
    }

    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings result2 = this.myEditor.getSnapshot();
        this.doApply(result2);
        return result2;
    }

    private void doApply(RunnerAndConfigurationSettings settings) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(runConfiguration.getProject());
        runManager.setBeforeRunTasks(runConfiguration, this.myBeforeRunStepsPanel.getTasks(true), false);
        RunnerAndConfigurationSettings runManagerSettings = runManager.getSettings(runConfiguration);
        if (runManagerSettings != null) {
            runManagerSettings.setEditBeforeRun(this.myBeforeRunStepsPanel.needEditBeforeRun());
            runManagerSettings.setActivateToolWindowBeforeRun(this.myBeforeRunStepsPanel.needActivateToolWindowBeforeRun());
        } else {
            settings.setEditBeforeRun(this.myBeforeRunStepsPanel.needEditBeforeRun());
            settings.setActivateToolWindowBeforeRun(this.myBeforeRunStepsPanel.needActivateToolWindowBeforeRun());
        }
    }

    public void addBeforeLaunchStep(BeforeRunTask<?> task2) {
        this.myBeforeRunStepsPanel.addTask(task2);
    }

    public List<BeforeRunTask> getStepsBeforeLaunch() {
        return Collections.unmodifiableList(this.myBeforeRunStepsPanel.getTasks(true));
    }

    @Override
    public void fireStepsBeforeRunChanged() {
        this.fireEditorStateChanged();
    }

    @Override
    public void titleChanged(String title) {
        this.myDecorator.setTitle(title);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myComponentPlace = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforeLaunchContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 0, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return ConfigurationSettingsEditorWrapper.this;
            }
            return null;
        }
    }
}

