/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDialog
extends DialogWrapper
implements RunConfigurable.RunDialogBase {
    private final Project myProject;
    private final RunConfigurable myConfigurable;
    private JComponent myCenterPanel;
    @NonNls
    public static final String HELP_ID = "reference.dialogs.rundebug";
    private final Executor myExecutor;

    public RunDialog(Project project2, Executor executor2) {
        super(project2, true);
        this.myProject = project2;
        this.myExecutor = executor2;
        String title = executor2.getId();
        this.setTitle(title);
        this.setOKButtonText(executor2.getStartActionText());
        this.setOKButtonIcon(executor2.getIcon());
        this.myConfigurable = new RunConfigurable(project2, this);
        this.init();
        this.myConfigurable.reset();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.RunDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    protected void doOKAction() {
        try {
            this.myConfigurable.apply();
        }
        catch (ConfigurationException e2) {
            Messages.showMessageDialog((Project)this.myProject, (String)e2.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    protected void dispose() {
        this.myConfigurable.disposeUIResources();
        super.dispose();
    }

    public static boolean editConfiguration(Project project2, RunnerAndConfigurationSettings configuration, String title) {
        return RunDialog.editConfiguration(project2, configuration, title, null);
    }

    public static boolean editConfiguration(@NotNull ExecutionEnvironment environment, @NotNull String title) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/impl/RunDialog", "editConfiguration"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/impl/RunDialog", "editConfiguration"));
        }
        return RunDialog.editConfiguration(environment.getProject(), environment.getRunnerAndConfigurationSettings(), title, environment.getExecutor());
    }

    public static boolean editConfiguration(Project project2, RunnerAndConfigurationSettings configuration, String title, final @Nullable Executor executor2) {
        SingleConfigurationConfigurable configurable = SingleConfigurationConfigurable.editSettings(configuration, executor2);
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(project2, (Configurable)configurable, DialogWrapper.IdeModalityType.IDE){
            {
                super(arg0, arg1, arg2);
                if (executor2 != null) {
                    this.setOKButtonText(executor2.getActionName());
                }
                if (executor2 != null) {
                    this.setOKButtonIcon(executor2.getIcon());
                }
            }
        };
        dialog2.setTitle(title);
        return dialog2.showAndGet();
    }

    @Override
    public Executor getExecutor() {
        return this.myExecutor;
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super(ExecutionBundle.message((String)"apply.action.name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                RunDialog.this.myConfigurable.apply();
            }
            catch (ConfigurationException e2) {
                Messages.showMessageDialog((Project)RunDialog.this.myProject, (String)e2.getMessage(), (String)ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
        }
    }
}

