/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerActionWrapper
extends ActionGroup {
    public static final Key<Pair<PsiElement, MyDataContext>> LOCATION_WRAPPER = Key.create((String)"LOCATION_WRAPPER");
    protected final PsiElement myElement;
    private final AnAction myOrigin;

    public LineMarkerActionWrapper(PsiElement element, @NotNull AnAction origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "<init>"));
        }
        this.myElement = element;
        this.myOrigin = origin;
        this.copyFrom(origin);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        if (this.myOrigin instanceof ActionGroup) {
            AnAction[] anActionArray = ((ActionGroup)this.myOrigin).getChildren(this.wrapEvent(e2));
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "getChildren"));
            }
            return anActionArray;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "getChildren"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean canBePerformed(DataContext context2) {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).canBePerformed(this.wrapContext(context2));
    }

    public boolean isDumbAware() {
        return this.myOrigin.isDumbAware();
    }

    public boolean isPopup() {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).isPopup();
    }

    public boolean hideIfNoVisibleChildren() {
        return this.myOrigin instanceof ActionGroup && ((ActionGroup)this.myOrigin).hideIfNoVisibleChildren();
    }

    public boolean disableIfNoVisibleChildren() {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).disableIfNoVisibleChildren();
    }

    public void update(AnActionEvent e2) {
        this.myOrigin.update(this.wrapEvent(e2));
    }

    @Nullable
    private AnActionEvent wrapEvent(@Nullable AnActionEvent e2) {
        if (e2 == null) {
            return null;
        }
        DataContext dataContext = this.wrapContext(e2.getDataContext());
        return new AnActionEvent(e2.getInputEvent(), dataContext, e2.getPlace(), e2.getPresentation(), e2.getActionManager(), e2.getModifiers());
    }

    @NotNull
    private DataContext wrapContext(DataContext dataContext) {
        Pair pair = (Pair)DataManager.getInstance().loadFromDataContext(dataContext, LOCATION_WRAPPER);
        if (pair == null || pair.first != this.myElement) {
            pair = Pair.pair((Object)this.myElement, (Object)((Object)new MyDataContext(dataContext)));
            DataManager.getInstance().saveInDataContext(dataContext, LOCATION_WRAPPER, (Object)pair);
        }
        DataContext dataContext2 = (DataContext)pair.second;
        if (dataContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "wrapContext"));
        }
        return dataContext2;
    }

    public void actionPerformed(AnActionEvent e2) {
        this.myOrigin.actionPerformed(this.wrapEvent(e2));
    }

    private class MyDataContext
    extends UserDataHolderBase
    implements DataContext {
        private final DataContext myDelegate;

        public MyDataContext(DataContext delegate2) {
            this.myDelegate = delegate2;
        }

        @Nullable
        public synchronized Object getData(@NonNls String dataId) {
            if (Location.DATA_KEY.is(dataId)) {
                return LineMarkerActionWrapper.this.myElement.isValid() ? new PsiLocation(LineMarkerActionWrapper.this.myElement) : null;
            }
            return this.myDelegate.getData(dataId);
        }
    }
}

