/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private static final Key<Boolean> MEDIATOR_KEY = Key.create((String)"KillableProcessHandler.Mediator.Process");
    private boolean myShouldKillProcessSoftly;
    private final boolean myMediatedProcess;

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableProcessHandler", "<init>"));
        }
        this(KillableProcessHandler.mediate(commandLine, withMediator));
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/KillableProcessHandler", "<init>"));
        }
        super(process2, commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/KillableProcessHandler", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/process/KillableProcessHandler", "<init>"));
        }
        super(process2, commandLine, charset);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
    }

    @NotNull
    protected static GeneralCommandLine mediate(@NotNull GeneralCommandLine commandLine, boolean withMediator) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableProcessHandler", "mediate"));
        }
        if (withMediator && SystemInfo.isWindows && MEDIATOR_KEY.get((UserDataHolder)commandLine) == null) {
            boolean mediatorInjected = RunnerMediator.injectRunnerCommand(commandLine);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Object)mediatorInjected);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/KillableProcessHandler", "mediate"));
        }
        return generalCommandLine;
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canKillProcessSoftly() {
        if (KillableProcessHandler.processCanBeKilledByOS((Process)this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.myMediatedProcess;
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e2) {
            LOG.warn((Throwable)e2);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canKillProcessSoftly() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows && this.myMediatedProcess) {
            return RunnerMediator.destroyProcess(this.myProcess, true);
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcess);
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS((Process)this.getProcess());
    }

    @Override
    public void killProcess() {
        this.killProcessTree(this.getProcess());
    }
}

