/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (executableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableName", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutablePath = Optional.empty();
        this.myExecutableName = executableName;
        this.myArgs = args;
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (executableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableName", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty((String)executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args;
    }

    public int getPid() {
        return this.myPid;
    }

    @NotNull
    public String getCommandLine() {
        String string2 = this.myCommandLine;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getCommandLine"));
        }
        return string2;
    }

    @NotNull
    public String getExecutableName() {
        String string2 = this.myExecutableName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableName"));
        }
        return string2;
    }

    @NotNull
    public Optional<String> getExecutableCannonicalPath() {
        Optional<String> optional = this.myExecutablePath.map(s2 -> {
            try {
                return new File((String)s2).getCanonicalPath();
            }
            catch (IOException e2) {
                return s2;
            }
        });
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableCannonicalPath"));
        }
        return optional;
    }

    @NotNull
    public String getExecutableDisplayName() {
        String string2 = StringUtil.trimEnd((String)this.myExecutableName, (String)".exe", (boolean)true);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableDisplayName"));
        }
        return string2;
    }

    @NotNull
    public String getArgs() {
        String string2 = this.myArgs;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getArgs"));
        }
        return string2;
    }

    public String toString() {
        return this.myPid + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'" + (this.myExecutablePath.isPresent() ? " " + this.myExecutablePath.get() : "");
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o2;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        if (!this.myCommandLine.equals(info.myCommandLine)) {
            return false;
        }
        return this.myExecutablePath.equals(info.myExecutablePath);
    }

    public int hashCode() {
        int result2 = this.myPid;
        result2 = 31 * result2 + this.myExecutableName.hashCode();
        result2 = 31 * result2 + this.myArgs.hashCode();
        result2 = 31 * result2 + this.myCommandLine.hashCode();
        return result2;
    }
}

