/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.InputStream;

class WinProcessManager {
    private static final Logger LOG = Logger.getInstance(WinProcessManager.class);

    private WinProcessManager() {
    }

    public static int getProcessPid(Process process2) {
        String processClassName = process2.getClass().getName();
        if (processClassName.equals("java.lang.Win32Process") || processClassName.equals("java.lang.ProcessImpl")) {
            try {
                long handle = (Long)ReflectionUtil.getField(process2.getClass(), (Object)process2, Long.TYPE, (String)"handle");
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE winHandle = new WinNT.HANDLE();
                winHandle.setPointer(Pointer.createConstant((long)handle));
                return kernel.GetProcessId(winHandle);
            }
            catch (Throwable e2) {
                throw new IllegalStateException(e2);
            }
        }
        throw new IllegalStateException("Unknown Process implementation: " + processClassName);
    }

    public static boolean kill(Process process2, boolean tree2) {
        return WinProcessManager.kill(-1, process2, tree2);
    }

    public static boolean kill(int pid, boolean tree2) {
        return WinProcessManager.kill(pid, null, tree2);
    }

    private static boolean kill(int pid, Process process2, boolean tree2) {
        LOG.assertTrue(pid > 0 || process2 != null);
        try {
            if (process2 != null) {
                pid = WinProcessManager.getProcessPid(process2);
            }
            String[] cmdArray = new String[]{"taskkill", "/f", "/pid", String.valueOf(pid), tree2 ? "/t" : ""};
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringUtil.join((String[])cmdArray, (String)" "));
            }
            Process p2 = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
            String output = FileUtil.loadTextAndClose((InputStream)p2.getInputStream());
            int res2 = p2.waitFor();
            if (res2 != 0 && (process2 == null || process2.isAlive())) {
                LOG.warn(StringUtil.join((String[])cmdArray, (String)" ") + " failed: " + output);
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            return true;
        }
        catch (Exception e2) {
            LOG.warn((Throwable)e2);
            return false;
        }
    }
}

