/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.CSVReader;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessListUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.impl.ProcessListUtil");
    private static final String WIN_PROCESS_LIST_HELPER_FILENAME = "WinProcessListHelper.exe";

    @NotNull
    public static ProcessInfo[] getProcessList() {
        List<ProcessInfo> result2 = ProcessListUtil.doGetProcessList();
        ProcessInfo[] processInfoArray = result2.isEmpty() ? ProcessInfo.EMPTY_ARRAY : result2.toArray(new ProcessInfo[result2.size()]);
        if (processInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "getProcessList"));
        }
        return processInfoArray;
    }

    @NotNull
    private static List<ProcessInfo> doGetProcessList() {
        if (SystemInfo.isWindows) {
            List<ProcessInfo> result2 = ProcessListUtil.getProcessListUsingWinNativeHelper();
            if (result2 != null) {
                List<ProcessInfo> list2 = result2;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list2;
            }
            LOG.info("Cannot get process list via WinProcessListHelper.exe, fallback to wmic");
            result2 = ProcessListUtil.getProcessListUsingWindowsWMIC();
            if (result2 != null) {
                List<ProcessInfo> list3 = result2;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list3;
            }
            LOG.info("Cannot get process list via wmic, fallback to tasklist");
            result2 = ProcessListUtil.getProcessListUsingWindowsTaskList();
            if (result2 != null) {
                List<ProcessInfo> list4 = result2;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list4;
            }
            LOG.error("Cannot get process list via wmic and tasklist");
        } else if (SystemInfo.isUnix) {
            List<ProcessInfo> result3 = SystemInfo.isMac ? ProcessListUtil.getProcessListOnMac() : ProcessListUtil.getProcessListOnUnix();
            if (result3 != null) {
                List<ProcessInfo> list5 = result3;
                if (list5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list5;
            }
            LOG.error("Cannot get process list");
        } else {
            LOG.error("Cannot get process list, unexpected platform: " + SystemInfo.OS_NAME);
        }
        List<ProcessInfo> list6 = Collections.emptyList();
        if (list6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
        }
        return list6;
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<String> command, @NotNull NullableFunction<String, List<ProcessInfo>> parser) {
        String output;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/process/impl/ProcessListUtil", "parseCommandOutput"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/execution/process/impl/ProcessListUtil", "parseCommandOutput"));
        }
        try {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(command));
            int exitCode = processOutput.getExitCode();
            if (exitCode != 0) {
                LOG.error("Cannot get process list, command '" + StringUtil.join(command, (String)" ") + "' exited with code " + exitCode + ", stdout:\n" + processOutput.getStdout() + "\nstderr:\n" + processOutput.getStderr());
            }
            output = processOutput.getStdout();
        }
        catch (ExecutionException e2) {
            LOG.error("Cannot get process list", (Throwable)e2);
            return null;
        }
        return (List)parser.fun((Object)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<ProcessInfo> getProcessListOnUnix() {
        File proc = new File("/proc");
        File[] processes = proc.listFiles();
        if (processes == null) {
            LOG.error("Cannot read /proc, not mounted?");
            return null;
        }
        ArrayList<ProcessInfo> result2 = new ArrayList<ProcessInfo>();
        for (File each : processes) {
            List cmdline;
            int pid = StringUtil.parseInt((String)each.getName(), (int)-1);
            if (pid == -1) continue;
            try (FileInputStream stream = new FileInputStream(new File(each, "cmdline"));){
                String cmdlineString = new String(FileUtil.loadBytes((InputStream)stream));
                cmdline = StringUtil.split((String)cmdlineString, (String)"\u0000");
            }
            catch (IOException e2) {
                continue;
            }
            if (cmdline.isEmpty()) continue;
            String executablePath = null;
            try {
                File exe = new File(each, "exe");
                if (!exe.getAbsolutePath().equals(exe.getCanonicalPath())) {
                    executablePath = exe.getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result2.add(new ProcessInfo(pid, StringUtil.join((Collection)cmdline, (String)" "), PathUtil.getFileName((String)((String)cmdline.get(0))), StringUtil.join(cmdline.subList(1, cmdline.size()), (String)" "), executablePath));
        }
        return result2;
    }

    @Nullable
    private static List<ProcessInfo> getProcessListOnMac() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,comm"), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)commandOnly -> ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,command"), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)full -> ProcessListUtil.parseMacOutput(commandOnly, full)))));
    }

    @Nullable
    static List<ProcessInfo> parseMacOutput(String commandOnly, String full) {
        List<MacProcessInfo> commands = ProcessListUtil.doParseMacOutput(commandOnly);
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (commands == null || fulls == null) {
            return null;
        }
        TIntObjectHashMap idToCommand = new TIntObjectHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result2 = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            String command;
            if (!idToCommand.containsKey(each.pid) || !each.commandLine.equals(command = (String)idToCommand.get(each.pid)) && !each.commandLine.startsWith(command + " ")) continue;
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.substring(command.length()).trim();
            result2.add(new ProcessInfo(each.pid, each.commandLine, name, args, command));
        }
        return result2;
    }

    @Nullable
    private static List<MacProcessInfo> doParseMacOutput(String output) {
        ArrayList result2 = ContainerUtil.newArrayList();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int pidStart = header.indexOf("PID");
        if (pidStart == -1) {
            return null;
        }
        int statStart = header.indexOf("S", pidStart);
        if (statStart == -1) {
            return null;
        }
        int userStart = header.indexOf("USER", statStart);
        if (userStart == -1) {
            return null;
        }
        int commandStart = header.indexOf("COMM", userStart);
        if (commandStart == -1) {
            return null;
        }
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line = lines[i2];
            try {
                String state;
                int pid = StringUtil.parseInt((String)line.substring(0, statStart).trim(), (int)-1);
                if (pid == -1 || (state = line.substring(statStart, userStart).trim()).contains("Z")) continue;
                String user = line.substring(userStart, commandStart).trim();
                String commandLine = line.substring(commandStart).trim();
                result2.add(new MacProcessInfo(pid, commandLine, user, state));
                continue;
            }
            catch (Exception e2) {
                LOG.error("Can't parse line '" + line + "'", (Throwable)e2);
            }
        }
        return result2;
    }

    private static List<ProcessInfo> getProcessListUsingWinNativeHelper() {
        try {
            File nativeHelper = ProcessListUtil.findNativeHelper();
            return ProcessListUtil.parseCommandOutput(Collections.singletonList(nativeHelper.getAbsolutePath()), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)ProcessListUtil::parseWinNativeHelperOutput));
        }
        catch (FileNotFoundException e2) {
            LOG.error((Throwable)e2);
            return null;
        }
    }

    private static List<ProcessInfo> parseWinNativeHelperOutput(String output) throws IllegalStateException {
        String[] strings = StringUtil.splitByLines((String)output, (boolean)false);
        ArrayList<ProcessInfo> result2 = new ArrayList<ProcessInfo>();
        int processCount = strings.length / 3;
        for (int i2 = 0; i2 < processCount; ++i2) {
            String args;
            String name;
            int offset = i2 * 3;
            int id = StringUtil.parseInt((String)strings[offset], (int)-1);
            if (id == -1 || id == 0 || StringUtil.isEmpty((String)(name = strings[offset + 1]))) continue;
            String commandLine = strings[offset + 2];
            if (commandLine.isEmpty()) {
                commandLine = name;
                args = "";
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            result2.add(new ProcessInfo(id, commandLine, name, args));
        }
        return result2;
    }

    private static String extractCommandLineArgs(String fullCommandLine, String executableName) {
        List commandLineList = StringUtil.splitHonorQuotes((String)fullCommandLine, (char)' ');
        if (commandLineList.isEmpty()) {
            return "";
        }
        String first = StringUtil.unquoteString((String)((String)commandLineList.get(0)));
        if (StringUtil.endsWithIgnoreCase((String)first, (String)executableName)) {
            List argsList = commandLineList.subList(1, commandLineList.size());
            return StringUtil.join(argsList, (String)" ");
        }
        return "";
    }

    private static File findNativeHelper() throws FileNotFoundException {
        String[] dirs;
        String prefix = "win";
        for (String dir : dirs = new String[]{PathManager.getBinPath(), PathManager.getHomePath() + "/ultimate/community/bin/" + prefix, PathManager.getHomePath() + "/community/bin/" + prefix, PathManager.getBinPath() + '/' + prefix}) {
            File file2 = new File(dir, WIN_PROCESS_LIST_HELPER_FILENAME);
            if (!file2.isFile()) continue;
            return file2;
        }
        throw new FileNotFoundException(String.format("%s was not found at: %s", WIN_PROCESS_LIST_HELPER_FILENAME, StringUtil.join((String[])dirs, (String)",")));
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsWMIC() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline,ExecutablePath"), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)output -> ProcessListUtil.parseWMICOutput(output)));
    }

    @Nullable
    static List<ProcessInfo> parseWMICOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/process/impl/ProcessListUtil", "parseWMICOutput"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int commandLineStart = header.indexOf("CommandLine");
        if (commandLineStart == -1) {
            return null;
        }
        int pidStart = header.indexOf("ProcessId");
        if (pidStart == -1) {
            return null;
        }
        int executablePathStart = header.indexOf("ExecutablePath");
        if (executablePathStart == -1) {
            return null;
        }
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line = lines[i2];
            int pid = StringUtil.parseInt((String)line.substring(pidStart, line.length()).trim(), (int)-1);
            if (pid == -1 || pid == 0) continue;
            String executablePath = line.substring(executablePathStart, pidStart).trim();
            String name = line.substring(0, commandLineStart).trim();
            if (name.isEmpty()) continue;
            String commandLine = line.substring(commandLineStart, executablePathStart).trim();
            String args = "";
            if (commandLine.isEmpty()) {
                commandLine = name;
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            result2.add(new ProcessInfo(pid, commandLine, name, args, executablePath));
        }
        return result2;
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsTaskList() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("tasklist.exe", "/fo", "csv", "/nh", "/v"), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)output -> ProcessListUtil.parseListTasksOutput(output)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<ProcessInfo> parseListTasksOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/process/impl/ProcessListUtil", "parseListTasksOutput"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        CSVReader reader = new CSVReader(new StringReader(output));
        try {
            while (true) {
                String[] next;
                if ((next = reader.readNext()) != null) {
                    String name;
                    if (next.length < 2) {
                        List<ProcessInfo> list2 = null;
                        return list2;
                    }
                    int pid = StringUtil.parseInt((String)next[1], (int)-1);
                    if (pid == -1 || (name = next[0]).isEmpty()) continue;
                    result2.add(new ProcessInfo(pid, name, name, ""));
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            LOG.error("Cannot parse listtasks output", (Throwable)e2);
            List<ProcessInfo> list3 = null;
            return list3;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result2;
    }

    private static class MacProcessInfo {
        final int pid;
        final String commandLine;
        final String user;
        final String state;

        public MacProcessInfo(int pid, String commandLine, String user, String state) {
            this.pid = pid;
            this.commandLine = commandLine;
            this.user = user;
            this.state = state;
        }
    }
}

