/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final String myConsoleTitle;
    private ProcessHandler myProcessHandler;
    private final String myWorkingDir;
    private T myConsoleView;
    @NotNull
    private final Project myProject;
    private ProcessBackedConsoleExecuteActionHandler myConsoleExecuteActionHandler;

    public AbstractConsoleRunnerWithHistory(@NotNull Project project2, @NotNull String consoleTitle, @Nullable String workingDir) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "<init>"));
        }
        this.myProject = project2;
        this.myConsoleTitle = consoleTitle;
        this.myWorkingDir = workingDir;
    }

    public void initAndRun() throws ExecutionException {
        Process process2 = this.createProcess();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myConsoleView = this.createConsoleView();
            if (this.myConsoleView instanceof JComponent) {
                ((JComponent)this.myConsoleView).setBorder((Border)new SideBorder(JBColor.border(), 1));
            }
            this.myProcessHandler = this.createProcessHandler(process2);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    AbstractConsoleRunnerWithHistory.this.finishConsole();
                }
            });
            this.myConsoleView.attachToProcess(this.myProcessHandler);
            this.createContentDescriptorAndActions();
            this.myProcessHandler.startNotify();
        });
    }

    protected Executor getExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    protected void createContentDescriptorAndActions() {
        Executor defaultExecutor = this.getExecutor();
        DefaultActionGroup toolbarActions2 = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions2, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        panel2.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel2);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(this.myConsoleView, this.myProcessHandler, (JComponent)panel2, this.constructConsoleTitle(this.myConsoleTitle), this.getConsoleIcon());
        contentDescriptor.setFocusComputable(() -> this.getConsoleView().getConsoleEditor().getContentComponent());
        contentDescriptor.setAutoFocusContent(this.isAutoFocusContent());
        List<AnAction> actions2 = this.fillToolBarActions(toolbarActions2, defaultExecutor, contentDescriptor);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions2, this.getConsoleView().getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions2, panel2);
        this.showConsole(defaultExecutor, contentDescriptor);
    }

    @Nullable
    protected Icon getConsoleIcon() {
        return null;
    }

    protected String constructConsoleTitle(@NotNull String consoleTitle) {
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "constructConsoleTitle"));
        }
        return new ConsoleTitleGen(this.myProject, consoleTitle, this.shouldAddNumberToTitle()).makeTitle();
    }

    public boolean isAutoFocusContent() {
        return true;
    }

    protected boolean shouldAddNumberToTitle() {
        return false;
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "showConsole"));
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, contentDescriptor);
    }

    protected void finishConsole() {
        this.myConsoleView.setEditable(false);
    }

    protected abstract T createConsoleView();

    @Nullable
    protected abstract Process createProcess() throws ExecutionException;

    protected abstract OSProcessHandler createProcessHandler(Process var1);

    public static void registerActionShortcuts(List<AnAction> actions2, JComponent component) {
        for (AnAction action2 : actions2) {
            if (action2.getShortcutSet() == null) continue;
            action2.registerCustomShortcutSet(action2.getShortcutSet(), component);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions2, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        ArrayList actionList = ContainerUtil.newArrayList();
        actionList.add(this.createStopAction());
        actionList.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        actionList.add(this.createConsoleExecAction(this.myConsoleExecuteActionHandler));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        toolbarActions2.addAll((Collection)actionList);
        return actionList;
    }

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    protected AnAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleExecuteActionHandler", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "createConsoleExecAction"));
        }
        String emptyAction = consoleExecuteActionHandler.getEmptyExecuteAction();
        return new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, consoleExecuteActionHandler, emptyAction, consoleExecuteActionHandler);
    }

    @NotNull
    protected abstract ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler();

    public T getConsoleView() {
        return this.myConsoleView;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory", "getProject"));
        }
        return project2;
    }

    public String getConsoleTitle() {
        return this.myConsoleTitle;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public ProcessBackedConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }
}

