/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RerunTestsAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public static final String ID = "RerunTests";
    private static final Set<RunContentDescriptor> REGISTRY = ContainerUtil.newHashSet();

    public static void register(final @NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        if (!Disposer.isDisposed((Disposable)descriptor2) && REGISTRY.add(descriptor2)) {
            Disposer.register((Disposable)descriptor2, (Disposable)new Disposable(){

                public void dispose() {
                    REGISTRY.remove(descriptor2);
                }
            });
        }
    }

    public static void register(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/RerunTestsAction", "actionPerformed"));
        }
        ArrayList descriptors = ContainerUtil.newArrayList(REGISTRY);
        for (RunContentDescriptor descriptor2 : descriptors) {
            RunContentManager runContentManager;
            if (Disposer.isDisposed((Disposable)descriptor2)) {
                REGISTRY.remove(descriptor2);
                continue;
            }
            Project project2 = e2.getProject();
            if (project2 == null || (runContentManager = ExecutionManager.getInstance((Project)project2).getContentManager()).getToolWindowByDescriptor(descriptor2) == null) continue;
            ExecutionUtil.restart((RunContentDescriptor)descriptor2);
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/RerunTestsAction", "update"));
        }
        e2.getPresentation().setEnabled(e2.getProject() != null);
    }
}

