/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrintable
implements Printable,
Disposable {
    public static final String NEW_LINE = "\n";
    protected final List<Printable> myNestedPrintables = new ArrayList<Printable>();
    private final PrintablesWrapper myWrapper = new PrintablesWrapper();
    protected int myExceptionMark;
    private int myCurrentSize = 0;
    private String myOutputFile = null;
    private String myFrameworkOutputFile;
    private static final ExecutorService ourTestExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"tests", (int)1);
    private static final Logger LOG = Logger.getInstance((String)("#" + PrintablesWrapper.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myWrapper.flush(this.myNestedPrintables);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOutputFile() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            ArrayList<Printable> printables = new ArrayList<Printable>(this.myNestedPrintables);
            CompositePrintable.invokeInAlarm(() -> this.printOutputFile(printables));
        }
    }

    public static void invokeInAlarm(Runnable runnable2) {
        CompositePrintable.invokeInAlarm(runnable2, !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
    }

    public static void invokeInAlarm(Runnable runnable2, boolean sync) {
        if (sync) {
            runnable2.run();
        } else {
            ourTestExecutorService.execute(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printOn(Printer printer2) {
        ArrayList<Printable> printables;
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            printables = new ArrayList<Printable>(this.myNestedPrintables);
        }
        this.myWrapper.printOn(printer2, printables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOwnPrintablesOn(Printer printer2) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            for (Printable printable : this.myNestedPrintables) {
                if (printable instanceof AbstractTestProxy) continue;
                printables.add(printable);
            }
        }
        this.myWrapper.printOn(printer2, printables, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable", "addLast"));
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myNestedPrintables.add(printable);
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NotNull Printable printable, int i2) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable", "insert"));
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            if (i2 >= this.myNestedPrintables.size()) {
                this.myNestedPrintables.add(printable);
            } else {
                this.myNestedPrintables.add(i2, printable);
            }
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myCurrentSize += this.myNestedPrintables.size();
            this.myNestedPrintables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            return this.myCurrentSize + this.myNestedPrintables.size();
        }
    }

    public void dispose() {
        this.clear();
        this.myWrapper.dispose();
    }

    public int getExceptionMark() {
        return this.myExceptionMark;
    }

    public void setExceptionMark(int exceptionMark) {
        this.myExceptionMark = exceptionMark;
    }

    public void setOutputFilePath(String outputFile) {
        this.myOutputFile = outputFile;
    }

    public void setFrameworkOutputFile(String frameworkOutputFile) {
        this.myFrameworkOutputFile = frameworkOutputFile;
    }

    public void printFromFrameworkOutputFile(Printer console) {
        if (this.myFrameworkOutputFile != null) {
            Runnable runnable2 = () -> {
                File inputFile = new File(this.myFrameworkOutputFile);
                if (inputFile.exists()) {
                    try {
                        String fileText = FileUtil.loadFile((File)inputFile);
                        console.print(fileText, ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e2) {
                        LOG.error((Throwable)e2);
                    }
                }
            };
            CompositePrintable.invokeInAlarm(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printOutputFile(List<Printable> currentPrintables) {
        if (this.myOutputFile != null && new File(this.myOutputFile).exists()) {
            try (final PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.myOutputFile), true));){
                for (Printable currentPrintable : currentPrintables) {
                    currentPrintable.printOn(new Printer(){

                        @Override
                        public void print(String text2, ConsoleViewContentType contentType) {
                            if (contentType != ConsoleViewContentType.SYSTEM_OUTPUT) {
                                printStream.print(text2);
                            }
                        }

                        @Override
                        public void printHyperlink(String text2, HyperlinkInfo info) {
                            printStream.print(text2);
                        }

                        @Override
                        public void onNewAvailable(@NotNull Printable printable) {
                            if (printable == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable$1", "onNewAvailable"));
                            }
                        }

                        @Override
                        public void mark() {
                        }
                    });
                }
            }
            catch (IOException e2) {
                LOG.error((Throwable)e2);
            }
        }
    }

    private class PrintablesWrapper {
        private static final String HYPERLINK = "hyperlink";
        private ConsoleViewContentType myLastSelected;
        private File myFile;
        private final MyFlushToFilePrinter myPrinter = new MyFlushToFilePrinter();
        private final Object myFileLock = new Object();

        private PrintablesWrapper() {
        }

        @Nullable
        private synchronized File getFile() {
            if (this.myFile == null) {
                try {
                    File tempFile = FileUtil.createTempFile((String)"idea_test_", (String)".out");
                    if (tempFile.exists()) {
                        this.myFile = tempFile;
                        return this.myFile;
                    }
                }
                catch (IOException e2) {
                    LOG.error((Throwable)e2);
                    return null;
                }
            }
            return this.myFile;
        }

        public synchronized void dispose() {
            if (this.myFile != null) {
                FileUtil.delete((File)this.myFile);
            }
        }

        public synchronized boolean hasOutput() {
            return this.myFile != null;
        }

        public void flush(List<Printable> printables) {
            if (printables.isEmpty()) {
                return;
            }
            ArrayList<Printable> currentPrintables = new ArrayList<Printable>(printables);
            Runnable request2 = () -> {
                Object object = this.myFileLock;
                synchronized (object) {
                    for (Printable printable : currentPrintables) {
                        printable.printOn(this.myPrinter);
                    }
                    this.myPrinter.close();
                }
                CompositePrintable.this.printOutputFile(currentPrintables);
            };
            CompositePrintable.invokeInAlarm(request2, ApplicationManager.getApplication().isUnitTestMode());
        }

        public void printOn(Printer console, List<Printable> printables) {
            this.printOn(console, printables, false);
        }

        public void printOn(Printer console, List<Printable> printables, boolean skipFileContent) {
            Runnable request2 = () -> {
                if (skipFileContent) {
                    this.readFileContentAndPrint(console, null, printables);
                    return;
                }
                File file2 = this.hasOutput() ? this.getFile() : null;
                Object object = this.myFileLock;
                synchronized (object) {
                    this.readFileContentAndPrint(console, file2, printables);
                }
            };
            CompositePrintable.invokeInAlarm(request2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFileContentAndPrint(Printer printer2, @Nullable File file2, List<Printable> nestedPrintables) {
            if (file2 != null) {
                try {
                    int lineNum = 0;
                    try (DataInputStream reader = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
                        while (reader.available() > 0 && !this.wasPrintableChanged(printer2)) {
                            if (lineNum == CompositePrintable.this.getExceptionMark() && lineNum > 0) {
                                printer2.mark();
                            }
                            String line = IOUtil.readString((DataInput)reader);
                            boolean printed = false;
                            for (ConsoleViewContentType contentType : ConsoleViewContentType.getRegisteredTypes()) {
                                String prefix = contentType.toString();
                                if (!line.startsWith(prefix)) continue;
                                String text2 = line.substring(prefix.length());
                                this.printText(printer2, text2, contentType);
                                this.myLastSelected = contentType;
                                printed = true;
                                break;
                            }
                            if (!printed) {
                                if (line.startsWith(HYPERLINK)) {
                                    new DiffHyperlink(IOUtil.readString((DataInput)reader), IOUtil.readString((DataInput)reader), IOUtil.readString((DataInput)reader), false).printOn(printer2);
                                } else {
                                    this.printText(printer2, line, this.myLastSelected != null ? this.myLastSelected : ConsoleViewContentType.NORMAL_OUTPUT);
                                }
                            }
                            ++lineNum;
                        }
                    }
                }
                catch (FileNotFoundException e2) {
                    LOG.info((Throwable)e2);
                }
                catch (IOException e3) {
                    LOG.error((Throwable)e3);
                }
            }
            for (int i2 = 0; i2 < nestedPrintables.size(); ++i2) {
                if (i2 == CompositePrintable.this.getExceptionMark() && i2 > 0) {
                    printer2.mark();
                }
                nestedPrintables.get(i2).printOn(printer2);
            }
        }

        private void printText(Printer printer2, String text2, ConsoleViewContentType contentType) {
            if (ConsoleViewContentType.NORMAL_OUTPUT.equals(contentType)) {
                printer2.printWithAnsiColoring(text2, contentType);
            } else {
                printer2.print(text2, contentType);
            }
        }

        private boolean wasPrintableChanged(Printer printer2) {
            return printer2 instanceof TestsOutputConsolePrinter && !((TestsOutputConsolePrinter)printer2).isCurrent(CompositePrintable.this);
        }

        private class MyFlushToFilePrinter
        implements Printer {
            private DataOutputStream myFileWriter;

            private MyFlushToFilePrinter() {
            }

            private DataOutputStream getFileWriter() {
                if (this.myFileWriter == null) {
                    try {
                        File file2 = PrintablesWrapper.this.getFile();
                        LOG.assertTrue(file2 != null);
                        this.myFileWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2, true)));
                    }
                    catch (FileNotFoundException e2) {
                        LOG.info((Throwable)e2);
                        return null;
                    }
                }
                return this.myFileWriter;
            }

            private void close() {
                if (this.myFileWriter != null) {
                    try {
                        this.myFileWriter.close();
                    }
                    catch (FileNotFoundException e2) {
                        LOG.info((Throwable)e2);
                    }
                    catch (IOException e3) {
                        LOG.error((Throwable)e3);
                    }
                    this.myFileWriter = null;
                }
            }

            @Override
            public void print(String text2, ConsoleViewContentType contentType) {
                try {
                    DataOutputStream writer = this.getFileWriter();
                    if (writer != null) {
                        IOUtil.writeString((String)(contentType.toString() + text2), (DataOutput)writer);
                    }
                }
                catch (FileNotFoundException e2) {
                    LOG.info((Throwable)e2);
                }
                catch (IOException e3) {
                    LOG.error((Throwable)e3);
                }
            }

            @Override
            public void printHyperlink(String text2, HyperlinkInfo info) {
                if (info instanceof DiffHyperlink.DiffHyperlinkInfo) {
                    DiffHyperlink diffHyperlink = ((DiffHyperlink.DiffHyperlinkInfo)info).getPrintable();
                    try {
                        DataOutputStream fileWriter = this.getFileWriter();
                        if (fileWriter != null) {
                            IOUtil.writeString((String)PrintablesWrapper.HYPERLINK, (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getLeft(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getRight(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getFilePath(), (DataOutput)fileWriter);
                        }
                    }
                    catch (FileNotFoundException e2) {
                        LOG.info((Throwable)e2);
                    }
                    catch (IOException e3) {
                        LOG.error((Throwable)e3);
                    }
                } else {
                    this.print(text2, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper$MyFlushToFilePrinter", "onNewAvailable"));
                }
            }

            @Override
            public void mark() {
            }
        }
    }
}

